        SUBROUTINE RICDAT
c=================================================================
C
c       Modify Initial Data to agree with RICHARDSON'S values.
C 
c=================================================================
c
c       size of grid
        PARAMETER (IM=13, JM=7, LM=5)
        PARAMETER (LMM1=LM-1)
c
c=================================================================
c
c       space for the basic INPUT variables 
        REAL PS(IM,JM), Z(IM,JM,LMM1)
        REAL U(IM,JM,LM),V(IM,JM,LM), DDDFF(IM,JM,LM)
        REAL OROG(IM,2*JM)
        COMMON / WINPUT / PS, Z, U, V, DDDFF, OROG
c
c       space for the basic PROGNOSTIC variables
        real P(IM,JM,LM),MU(IM,JM,LM),MV(IM,JM,LM),TTOP(IM,JM)
        COMMON / WPROG / P, MU, MV, TTOP
c
C
c=================================================================
c
c       Level 2 pressures.
        P(7,5,1) = 20470
        P(6,4,1) = 20470
        P(8,4,1) = 20490
        P(5,4,1) = 20300
        P(7,4,1) = 20500
        P(9,4,1) = 20440
        P(6,3,1) = 20390
        P(8,3,1) = 20430
        P(7,3,1) = 20340
c
c       Level 4 pressures.
        P(7,5,2) = 40900
        P(6,4,2) = 40830
        P(8,4,2) = 40910
        P(5,4,2) = 40490
        P(7,4,2) = 40900
        P(9,4,2) = 40820
        P(6,3,2) = 40620
        P(8,3,2) = 40750
        P(7,3,2) = 40340
c
c       Level 6 pressures.
        P(7,5,3) = 60860
        P(6,4,3) = 60670
        P(8,4,3) = 60870
        P(5,4,3) = 60440
        P(7,4,3) = 60790
        P(9,4,3) = 60680
        P(6,3,3) = 60500
        P(8,3,3) = 60650
        P(7,3,3) = 60310
C
c       Level 8 pressures.
        P(7,5,4) = 79830
        P(6,4,4) = 79500
        P(8,4,4) = 79790
        P(5,4,4) = 79280
        P(7,4,4) = 79600
        P(9,4,4) = 79780
        P(6,3,4) = 79490
        P(8,3,4) = 79670
        P(7,3,4) = 79570
c
c       Level G pressures.
        P(7,5,5) = 98830
        P(6,4,5) = 98340
        P(8,4,5) = 97630
        P(5,4,5) = 97440
        P(7,4,5) = 96260
        P(9,4,5) = 98820
        P(6,3,5) = 87460
        P(8,3,5) = 84580
        P(7,3,5) = 99720
c
c=================================================================
c
c       Level 1 U-momenta.
        MU(7,5,1) = -6500
        MU(6,5,1) = -7000
        MU(8,5,1) = -16000
        MU(5,4,1) = -3000
        MU(7,4,1) = -5600
        MU(9,4,1) = -10000
        MU(6,4,1) =  2700
        MU(8,4,1) =  0
        MU(7,3,1) = -5000
c
c       Level 3 U-momenta.
        MU(7,5,2) =  12700
        MU(6,5,2) = -6200
        MU(8,5,2) =  4000
        MU(5,4,2) = -24500
        MU(7,4,2) = -14600
        MU(9,4,2) =  0
        MU(6,4,2) = -32800
        MU(8,4,2) = -16600
        MU(7,3,2) = -28000
c
c       Level 5 U-momenta.
        MU(7,5,3) =  8100
        MU(6,5,3) = -11400
        MU(8,5,3) = -6000
        MU(5,4,3) = -22300
        MU(7,4,3) = -9500
        MU(9,4,3) = -5500
        MU(6,4,3) = -13600
        MU(8,4,3) = -9500
        MU(7,3,3) = -17500
c
c       Level 7 U-momenta.
        MU(7,5,4) = -8100
        MU(6,5,4) = -9100
        MU(8,5,4) = -6000
        MU(5,4,4) = -9100
        MU(7,4,4) = -5200
        MU(9,4,4) = -2500
        MU(6,4,4) = -3300
        MU(8,4,4) = -1900
        MU(7,3,4) = -10500
c
c       Level 9 U-momenta.
        MU(7,5,5) = -19800
        MU(6,5,5) = -16000
        MU(8,5,5) = -21900
        MU(5,4,5) = -1800
        MU(7,4,5) = -11000
        MU(9,4,5) = -19000
        MU(6,4,5) =  4800
        MU(8,4,5) = -6500
        MU(7,3,5) = -15500
c
c       Level 1 V-momenta.
        MV(7,5,1) =  800
        MV(5,4,1) = -11000
        MV(7,4,1) = -1800
        MV(9,4,1) = -3200
        MV(7,3,1) =  8000
c
c       Level 3 V-momenta.
        MV(7,5,2) = -10400
        MV(5,4,2) =  30000
        MV(7,4,2) = -6200
        MV(9,4,2) = -26000
        MV(7,3,2) =  4100
c
c       Level 5 V-momenta.
        MV(7,5,3) = -2500
        MV(5,4,3) =  15800
        MV(7,4,3) =  2900
        MV(9,4,3) = -13500
        MV(7,3,3) =  15000
c
c       Level 7 V-momenta.
        MV(7,5,4) =  0
        MV(5,4,4) =  8700
        MV(7,4,4) =  5800
        MV(9,4,4) =  4800
        MV(7,3,4) =  8000
c
c       Level 9 V-momenta.
        MV(7,5,5) =  8400
        MV(5,4,5) =  1500
        MV(7,4,5) =  5500
        MV(9,4,5) =  16000
        MV(7,3,5) =  4000
c
c=================================================================
c
c       Level 1 temperatures.
        TTOP(6,5) = 214
        TTOP(8,5) = 216
        TTOP(5,5) = 215
        TTOP(7,5) = 214
        TTOP(9,5) = 216
        TTOP(6,4) = 212
        TTOP(8,4) = 214
        TTOP(5,4) = 214
        TTOP(7,4) = 212
        TTOP(9,4) = 214
        TTOP(6,3) = 214
        TTOP(8,3) = 214
        TTOP(7,3) = 213
c
c=================================================================
c
c
        RETURN
        end
