# code to fit an ERGM to the Caltech dataset and produce goodness-of-fit plots and a roc curve
library(ergm)
# read in the adjacency matrix
Y<-as.matrix(read.table("CaltechY.dat"))
# replace the diagonals with 1s
diag(Y)<-1
net<-network(Y,directed=FALSE)
print(system.time(ergm.fit<-ergm(net~edges+triangle+gwdegree(1.5))))
readline(prompt="finished fitting the ergm; please hit enter to continue")
# now take a look at the goodness-of-fit plots
par(ask=1)
ergm.gof<-gof(ergm.fit,GOF=~degree)
plot(ergm.gof)
ergm.gof<-gof(ergm.fit,GOF=~esp)
plot(ergm.gof)
ergm.gof<-gof(ergm.fit,GOF=~distance)
plot(ergm.gof)


# link prediction
N<-nrow(Y)
sim.ergm<-simulate.ergm(ergm.fit,nsim=100)
probs<-matrix(apply(sapply(sim.ergm$networks,as.sociomatrix),1,sum),N)
source("roc.R")
roc(probs,Y)
