# read in the covariate information
localinfo<-read.csv("Caltech_localinfo.csv")
# read in the adjacency matrix
Y<-as.matrix(read.table("CaltechY.dat"))
# replace the diagonals with 1s
diag(Y)<-1
DD<-apply(Y,2,sum)
# construct the Laplacian
L<-diag(1,762)-diag(DD^(-0.5))%*%Y%*%diag(DD^(0.5)) 
# perform Singular-Vector Decomposition
spectral<-svd(L)
# cluster the first 8 eigenvetors (there are 8 dorms)
clusts<-kmeans(spectral$u[,1:8],8)
# make a contingency table of the dorms and the SVD clustering
dorms.table<-table(localinfo$dorm, clusts$cluster)
# check contingency 
library(vcd)
print(assocstats(dorms.table))
