Y<-as.matrix(read.table("CaltechY.dat"))
# replace the diagonals with 1s
diag(Y)<-0

N<- nrow(Y)

library(igraph) 
g<- graph.adjacency(Y, mode="undirected")

ebc <- edge.betweenness.community(g)

q<- 0

for(i in 1:length(ebc$removed.edges)){
  g2 <- delete.edges(g, ebc$removed.edges[1:i])
  cl <- clusters(g2)$membership
  q[i] <- modularity(g, cl)
}

k1<- which((q)==max(q))[1]
g2<- delete.edges(g, ebc$removed.edges[1:k1])
cl<- clusters(g2)$membership

sort(table(cl)) ## One big group, lots of isolated nodes.

## Code taken from igraph notes - originally for karate dataset. url: http://igraph.sourceforge.net/screenshots2.html