# code to fit the LPCM to the Caltech data and produce goodness-of-fit measures and plots
library(VBLPCM)
# read in the covariate information
localinfo<-read.csv("Caltech_localinfo.csv")
# read in the adjacency matrix
Y<-as.matrix(read.table("CaltechY.dat"))
# replace the diagonals with 1s
diag(Y)<-1
net<-network(Y,directed=FALSE)
v.start<-vblpcmstart(net,G=G,d=dd,mode="rsocial")
print(system.time(v.fit<-vblpcmfit(v.start, STRAT=0.1, STEPS=100)))
readline(prompt="finished fitting the LPCM; please hit enter to continue")
# make a contingency table of the dorms and the SVD clustering
dorms.table<-table(localinfo$dorm, apply(v.fit$V_lambda,2,which.max))
# check contingency 
library(vcd)
print(assocstats(dorms.table))
par(ask=1)
# now take a look at the goodness-of-fit plots
v.gof<-gof(v.fit,GOF=~degree)
plot(v.gof)
v.gof<-gof(v.fit,GOF=~esp)
plot(v.gof)
v.gof<-gof(v.fit,GOF=~distance)
plot(v.gof)

# link prediction
N<-nrow(Y)
probs<-predict(v.fit)
source("roc.R")
roc(probs,Y)
