# code to fit a blockmodel to the Caltech data 
# blocks are based on dorms
library(sna)
# read in the covariate information
localinfo<-read.csv("Caltech_localinfo.csv")
# read in the adjacency matrix
Y<-as.matrix(read.table("CaltechY.dat"))
net<-network(Y,directed=FALSE)
b<-blockmodel(net,localinfo$dorm)
# now visualise the blockmodel
image(b$blocked.data,col=c(0,1))
