## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----global_options, include=FALSE--------------------------------------------
knitr::opts_chunk$set(fig.pos = "H")

## -----------------------------------------------------------------------------
require(MOSAIC)
set.seed(123)

## ----eval=T, echo=T-----------------------------------------------------------
fpath=system.file("extdata", package="MOSAIC")
mosaic.result=run_mosaic("simulated", fpath, chrnos=18:22, A=2, NUMI=3,
                         pops=c("English","Mandenka"), gens=30)

## ----eval=F, echo=T-----------------------------------------------------------
#  load("MOSAIC_RESULTS/simulated_2way_1-3_18-22_148_60_0.99_100.RData") # model parameters, etc
#  load("MOSAIC_RESULTS/localanc_simulated_2way_1-3_18-22_148_60_0.99_100.RData") # local ancestry

## ----message=F----------------------------------------------------------------
attach(mosaic.result)

## ----eval=F, echo=T-----------------------------------------------------------
#  plot_all_mosaic(pathout="MOSAIC_RESULTS/",target)

## ----fig.height=3-------------------------------------------------------------
ord.Mu=plot_Mu(Mu,alpha,NL)

## ----fig.height=3-------------------------------------------------------------
ord.Fst=plot_Fst(all_Fst$panels,ord=T)

## ----fig.height=3-------------------------------------------------------------
tmp=plot_Fst(all_Fst$panels,reverse=FALSE)

## ----fig.height=2.2-----------------------------------------------------------
fitcc=plot_coanccurves(acoancs,dr)

## ----fig.height=4.2, message=FALSE--------------------------------------------
bi.fit.cc=bootstrap_individuals_coanc_curves(acoancs, dr, alpha) 
hist(unlist(bi.fit.cc$boot.gens), xlab="generations",main="bootstrap individuals") 

## ----fig.height=4.2, message=FALSE--------------------------------------------
bc.fit.cc=bootstrap_chromosomes_coanc_curves(acoancs, dr, localanc, alpha) 
hist(unlist(bc.fit.cc$boot.gens), xlab="generations",main="bootstrap chromosomes") 

## ----fig.height=2.5-----------------------------------------------------------
chr=1
ind=2
dipplot(chr,ind,g.loc[[chr]],ind,localanc,xlab=paste("Position on Chromosome",chrnos[chr]),ylab="")
mp=axTicks(1,axp=round(c(min(g.loc[[chr]]),max(g.loc[[chr]]),5)))
axis(1,at=mp,labels=signif(mp,3))

## ----eval=FALSE, echo=T-------------------------------------------------------
#  plot_localanc(chrnos,g.loc,localanc,g.true_anc)

## ----eval=TRUE, echo=T--------------------------------------------------------
ind=2
karyogram(A, chrnos, localanc, g.loc, GpcM, ind, dist = "genetic", g.true_anc = g.true_anc)

## -----------------------------------------------------------------------------
dip_localanc=dip(localanc)

## -----------------------------------------------------------------------------
chr=1
m_localanc=plot_mean_localanc(chr,chrnos,g.loc,localanc,ret=TRUE)

## -----------------------------------------------------------------------------
dip_expected_fr2(localanc)

## -----------------------------------------------------------------------------
dip_fr2(localanc,g.true_anc)

## -----------------------------------------------------------------------------
fpath=system.file("extdata", package="MOSAIC")
local_pos=grid_to_pos(localanc, fpath, g.loc, chrnos)

## -----------------------------------------------------------------------------
fpath=system.file("extdata", package="MOSAIC")
true_anc_pos=grid_to_pos(g.true_anc, fpath, g.loc, chrnos)
dip_fr2(local_pos,true_anc_pos)

## ----eval=F, echo=T-----------------------------------------------------------
#  # run MOSAIC on chromosomes 18 to 21 only to estimate parameters
#  fpath=system.file("extdata", package="MOSAIC")
#  mosaic.result=run_mosaic("Moroccan", fpath, 18:21,A=2,NUMI=4)
#  load("MOSAIC_RESULTS/Moroccan_2way_1-4_18-21_162_60_0.99_100.RData") # load the results.
#  # Note that you could also use attach(mosaic.result) for this, if still in the same R session
#  # or read parameters from the log file using paras=extract_paras(extract_log(EMlogfile))
#  # then run MOSAIC on chromosome 22 using the parameter estimates from the previous run
#  mosaic.result22=run_mosaic("Moroccan", fpath, 22, A=2, NUMI=4, EM=F, # don't update via EM here
#  			   init.PI=PI,init.rho=rho,init.Mu=Mu,init.theta=theta)

## ----eval=FALSE, echo=T-------------------------------------------------------
#  fpath=system.file("extdata", package="MOSAIC")
#  mosaic.result=run_mosaic("simulated", fpath, 18:22, A=2, NUMI=3,
#  			 pops=c("English","Mandenka", "French", "Yoruba"))

## ----eval=FALSE, echo=T-------------------------------------------------------
#  ord.Mu=plot_Mu(Mu,alpha,NL,showgradient=TRUE)

## ----eval=F, echo=T-----------------------------------------------------------
#  ?run_mosaic

