close all
clear all

kvkh=0.01;

xd=4;
dt=0.5*1e-3/kvkh;
tol=0.002;
fac=1;
zd=1.05;
N=100;
pltno=1e1;
ooa=2;
ooa2=8; 

% Create matrices and initial shape
X=repmat(linspace(0,xd,N),N,1);Z=repmat(linspace(0,zd,N),N,1)';zs=Z(:,end);xs=X(end,:);dx=xs(2)-xs(1);dz=zs(2)-zs(1);

hz=xs;
hz(xs>=1)=0;
hz(xs<1)=fac;hz0=hz;

id=find(hz>tol,1,'last');
in = inpolygon(X(:),Z(:),[xs(1:id),xs(id),0,0],[hz(1:id),0,0,hz(1)]);
rho=X(:);
rho(in)=1;
rho(~in)=0;

[Dx, Dz] = getNonCompactFDmatrix2D(N,N,dx,dz,1,ooa);
[Dxx, Dzz] = getNonCompactFDmatrix2D(N,N,dx,dz,2,ooa);
Dx1 = getNonCompactFDmatrix(N,dx,1,ooa2);

[L0,BND]=build_matrices(N);
BNDi=find(BND);

% First iteration
A=eye(N^2);
[L,F] = update_matrices(Dxx,kvkh*Dzz,Dz,rho,kvkh,dz,zs,zd,N,BNDi,L0);
irho=find(rho==0);
L(irho,:)=A(irho,:);
F(irho)=0;
p=L\F;
pr=Dx*p;
pz=Dz*p;
P=reshape(p,N,N);
Rho=reshape(rho,N,N);
Px=reshape(pr,N,N);
Pz=reshape(pz,N,N);
U=-Px;
plot_sol(X,Z,P,Rho);
plot(xs,hz,'w','linewidth',2)
pause(0.01)

V=trapz(xs,hz);
t=0;
i=0;Xs=[];Zs=[];vols=[];ts=[];errs=[];
XX=xs(id);
hs=[];
while hz(end)<tol
    t=t+dt;i=i+1;
    
    flux=trapz(zs,U)';
    
        dfdx=1/dx*(flux(2:end)-flux(1:end-1))';
        hz(2:end)=hz(2:end)-dt*dfdx;
    
    % Apply BC
    hz(1)=hz(2);
    
    % update density
    id=find(hz>tol,1,'last');
    in = inpolygon(X(:),Z(:),[xs(1:id),xs(id),0,0],[hz(1:id),0,0,hz(1)]);
    rho(in)=1;
    rho(~in)=0;
    Rho=reshape(rho,N,N);
    
    [L,F] = update_matrices(Dxx,kvkh*Dzz,Dz,rho,kvkh,dz,zs,zd,N,BNDi,L0);
    
    irho=find(rho==0);
    L(irho,:)=A(irho,:);
    F(irho)=0;
    p=L\F;
    P=reshape(p,N,N);
    pr=Dx*p;
    pz=Dz*p;
    Px=reshape(pr,N,N);
    Pz=reshape(pz,N,N);
    U=-Px;
    U(Rho==0)=0;
    
    Phyd=cumtrapz(Z(:,1),-Rho);
    Phyd=Phyd-Phyd(end,:);
    
    % calculate metrics
    vol=trapz(xs,hz);
    XX=xs(id);
    ZZ=max(hz);
    err=max(max(abs(P-Phyd)));
    
    Xs=[Xs,XX];
    Zs=[Zs,ZZ];
    ts=[ts,t];
    vols=[vols,vol];
    errs=[errs,err];
    
    % plot solution
    if mod(i,pltno)==0
        plot_sol(X,Z,P,Rho);
        plot(xs,hz,'w','linewidth',2)
        plot(xs,hz0,'w:','linewidth',2)
        plot(XX,0,'w.','markersize',40)
        title(strcat('$$t=',num2str(t),'$$'),'interpreter','latex')
        pause(0.01)
    end
    hs=[hs;hz];
end
