#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include<time.h>
#include<gsl/gsl_randist.h>
#include<gsl/gsl_cdf.h>

#include "rangen.h"
#include "Mem.h"
#include "LinAlg.h"

#define repeat for(;;)
#define M_LN_SQRT_2PI   0.918938533204672741780329736406

/* Function to generate an exponential random variate */ 
double rexp()
{
 double u, v;

 u = (double) rand() / RAND_MAX;
 v = -log(u);
 return v;
 
}

/* Function to generate a normal random variable mean 0, sd 1. */
double gaussrand()
{
   static double V2, fac;
   static int phase = 0;
   double S, Z, U1, U2, V1;

    if (phase)
     Z = V2 * fac;
  else
  {
 do {
  U1 = (double)rand() / RAND_MAX;
  U2 = (double)rand() / RAND_MAX;
  V1 = 2 * U1 - 1;
  V2 = 2 * U2 - 1;
  S = V1 * V1 + V2 * V2;
  } while(S >= 1);

  fac = sqrt (-2 * log(S) / S);
  Z = V1 * fac;
 }

  phase = 1 - phase;

 return Z;
}



/* Function to generate a gaussian random variate */
double rnorm()
{
 static double V2, fac;
 static int phase = 0;
 double S, Z, U1, U2, V1;

 if (phase)
 Z = V2 * fac;
 else
 {
 do{
  U1 = (double)rand() / RAND_MAX;
  U2 = (double)rand() / RAND_MAX;
  V1 = 2 * U1 - 1;
  V2 = 2 * U2 - 1;
  S = V1 * V1 + V2 * V2;
 } while(S >= 1);

 fac = sqrt (-2 * log(S) / S);
 Z = V1 * fac;
 }

  phase = 1 - phase;
  return Z;
}                                   /* End of rnorm() function */

void rmvnorm_1d(int no_items, double **Sigma, double *res){
	int j;
	double *Z = OnedDoubleMemAlloc(no_items);
	double **Chol = TwodDoubleMemAlloc(no_items, no_items);

	const gsl_rng_type *T;
  gsl_rng *r;
  gsl_rng_env_setup();
  T=gsl_rng_default;
  r = gsl_rng_alloc(T);
  // seed the random number generator
/*  long iran0 = 0;*/
/*  long *iran = &iran0;*/
/*  double seed = ran0(iran);*/
/*  gsl_rng_set(r, seed); */
  gsl_rng_set(r, rand()); 

	//	Fill Z with N(0,1) deviates
		for(j=0; j<no_items; j++)
			Z[j] = gsl_ran_gaussian(r, 1);
  gsl_rng_free (r);

	//Compute cholesky factor of covariance matrix
	Cholesky(Sigma, no_items, Chol);

	double *res_temp = DoubleMatVecMul(Chol, no_items, no_items, Z, no_items, 1);

	for(j=0; j<no_items; j++)
		res[j] = res_temp[j];

	free(res_temp);
	free(Z);
	freeDoubleMat(Chol, no_items);
}

/* Function to simulate "no_obs" observations from a MVN(mu, Sigma) distribution */
void rmvnorm(int no_obs, int no_items, double **Sigma, double **res){
	int i, j;
	double **Z = TwodDoubleMemAlloc(no_obs, no_items);
	double **Chol = TwodDoubleMemAlloc(no_items, no_items);

	const gsl_rng_type *T;
  gsl_rng *r;
  gsl_rng_env_setup();
  T=gsl_rng_default;
  r = gsl_rng_alloc(T);
  //seed the random number generator
  gsl_rng_set(r,rand()); 

	//	Fill Z with N(0,1) deviates
	for(i=0; i<no_obs; i++){
		for(j=0; j<no_items; j++)
			Z[i][j] = gsl_ran_gaussian(r, 1);
	}
  gsl_rng_free (r);

	//Compute cholesky factor of covariance matrix
	Cholesky(Sigma, no_items, Chol);

	double **res_temp = DoubleMatMul(Z, no_obs, no_items, Chol, no_items, no_items);
	for(i=0; i<no_obs; i++){
		for(j=0; j<no_items; j++)
			res[i][j] = res_temp[i][j];
	}

	freeDoubleMat(res_temp, no_obs);
	freeDoubleMat(Z, no_obs);
	freeDoubleMat(Chol, no_items);
}

/* **WRONG**:::Function to generate a gamma random variate. a is the mean of a Gamma i.e. shape*scale. scale is scale parameter. */
/* EDIT: a is the shape parameter, scale is the scale parameter */
double rgamma(double a, double scale)
{
/* Constants : */
    const static double sqrt32 = 5.656854;
    const static double exp_m1 = 0.36787944117144232159;/* exp(-1) = 1/e */

    /* Coefficients q[k] - for q0 = sum(q[k]*a^(-k))
     * Coefficients a[k] - for q = q0+(t*t/2)*sum(a[k]*v^k)
     * Coefficients e[k] - for exp(q)-1 = sum(e[k]*q^k)
     */
    const static double q1 = 0.04166669;
    const static double q2 = 0.02083148;
    const static double q3 = 0.00801191;
    const static double q4 = 0.00144121;
    const static double q5 = -7.388e-5;
    const static double q6 = 2.4511e-4;
    const static double q7 = 2.424e-4;

    const static double a1 = 0.3333333;
    const static double a2 = -0.250003;
    const static double a3 = 0.2000062;
    const static double a4 = -0.1662921;
    const static double a5 = 0.1423657;
    const static double a6 = -0.1367177;
    const static double a7 = 0.1233795;

    /* State variables [FIXME for threading!] :*/
    static double aa = 0.;
    static double aaa = 0.;
    static double s, s2, d;    /* no. 1 (step 1) */
    static double q0, b, si, c;/* no. 2 (step 4) */

    double e, p, q, r, t, u, U, v, w, x, ret_val;
 

    if (!finite(a) || !finite(scale))
    {
     printf("Error! Non-finite a and/or scale! \t a = %lf. \t scale = %lf.\n", a, scale);
     exit(0);
    }


    if (a < 1.) { /* GS algorithm for parameters a < 1 */

    e = 1.0 + exp_m1 * a;
    repeat {
        U = (double) rand() / RAND_MAX;
        p = e * U;
        if (p >= 1.0) {
        x = -log((e - p) / a);
        if (rexp() >= (1.0 - a) * log(x))
            break;
        } else {
        x = exp(log(p) / a);
        if (rexp() >= x)
            break;
        }
    }
    return scale * x;
   }
    /* --- a >= 1 : GD algorithm --- */

    /* Step 1: Recalculations of s2, s, d if a has changed */
    if (a != aa) {
    aa = a;
    s2 = a - 0.5;
    s = sqrt(s2);
    d = sqrt32 - s * 12.0;
    }
    /* Step 2: t = standard normal deviate,
               x = (s,1/2) -normal deviate. */

    /* immediate acceptance (i) */
    t = rnorm();
    x = s + 0.5 * t;
    ret_val = x * x;
    if (t >= 0.0)
    return scale * ret_val;

    /* Step 3: u = 0,1 - uniform sample. squeeze acceptance (s) */
    u = (double) rand() / RAND_MAX;
    if (d * u <= t * t * t)
    return scale * ret_val;

    /* Step 4: recalculations of q0, b, si, c if necessary */

    if (a != aaa) {
    aaa = a;
    r = 1.0 / a;
    q0 = ((((((q7 * r + q6) * r + q5) * r + q4) * r + q3) * r
           + q2) * r + q1) * r;

    /* Approximation depending on size of parameter a */
    /* The constants in the expressions for b, si and c */
    /* were established by numerical experiments */

    if (a <= 3.686) {
        b = 0.463 + s + 0.178 * s2;
        si = 1.235;
        c = 0.195 / s - 0.079 + 0.16 * s;
    } else if (a <= 13.022) {
        b = 1.654 + 0.0076 * s2;
        si = 1.68 / s + 0.275;
        c = 0.062 / s + 0.024;
    } else {
        b = 1.77;
        si = 0.75;
        c = 0.1515 / s;
    }
    }
    /* Step 5: no quotient test if x not positive */

    if (x > 0.0) {
    /* Step 6: calculation of v and quotient q */
    v = t / (s + s);
    if (fabs(v) <= 0.25)
        q = q0 + 0.5 * t * t * ((((((a7 * v + a6) * v + a5) * v + a4) * v
                      + a3) * v + a2) * v + a1) * v;
    else
        q = q0 - s * t + 0.25 * t * t + (s2 + s2) * log(1.0 + v);


    /* Step 7: quotient acceptance (q) */
    if (log(1.0 - u) <= q)
        return scale * ret_val;
    }

    repeat {
    /* Step 8: e = standard exponential deviate
     *  u =  0,1 -uniform deviate
     *  t = (b,si)-double exponential (laplace) sample */
    e = rexp();
    u = (double) rand()/RAND_MAX;
    u = u + u - 1.0;
    if (u < 0.0)
        t = b - si * e;
    else
        t = b + si * e;
    /* Step  9:  rejection if t < tau(1) = -0.71874483771719 */
    if (t >= -0.71874483771719) {
        /* Step 10:  calculation of v and quotient q */
        v = t / (s + s);
        if (fabs(v) <= 0.25)
        q = q0 + 0.5 * t * t *
            ((((((a7 * v + a6) * v + a5) * v + a4) * v + a3) * v
              + a2) * v + a1) * v;
        else
        q = q0 - s * t + 0.25 * t * t + (s2 + s2) * log(1.0 + v);
        /* Step 11:  hat acceptance (h) */
        /* (if q not positive go to step 8) */
        if (q > 0.0) {
        w = expm1(q);
        /*  ^^^^^ original code had approximation with rel.err < 2e-7 */
        /* if t is rejected sample again at step 8 */
        if (c * fabs(u) <= w * exp(e - 0.5 * t * t))
            break;
        }
    }
    } /* repeat .. until  `t' is accepted */
    x = s + 0.5 * t;

    return scale * x * x;
}                   /* End of rgamma function. */


/* Returns the value ln[gamma(xx)] for xx > 0. */
double gammaln(double xx)
{
 double x, y, tmp, ser;
 static double cof[6]={76.18009172947146,-86.50532032941677,
 24.01409824083091,-1.231739572450155,
 0.1208650973866179e-2,-0.5395239384953e-5};
 int j;

 y=x=xx;
 tmp=x+5.5;
 tmp -= (x+0.5)*log(tmp);
 ser=1.000000000190015;
 for(j=0; j<=5; j++)
  ser += cof[j]/++y;
 return -tmp+log(2.5066282746310005*ser/x);
}


/* Function to evaluate a Gamma distribution at the point x with shape alpha and scale beta. */
double dgamma(double x, double shape, double scale)
{
 double frac, xpart, epart;
 
 if(shape <= 0 || scale <= 0)
 {
  printf("Error in function dgamma! x = %lf. \t shape = %lf. \t scale = %lf.\n", x, shape, scale);
  exit(0);
 }
 
 if(x <= 0)
 {
  return 0;
 }

 frac = exp(gammaln(shape)) * pow(scale, shape);
 frac = pow(frac, -1);
 xpart = pow(x, shape-1);
 epart = exp(-x/scale);

 return frac * xpart * epart;
}               /* End of dgamma function */




/* Function to return the minimum of 2 numbers */
double fmin2(double x, double y)
{
    return (x < y) ? x : y;
}



/* Function to simulate binomial variates */
double rbinom(double nin, double pp)
{
    static double c, fm, npq, p1, p2, p3, p4, qn;
    static double xl, xll, xlr, xm, xr;

    static double psave = -1.0;
    static int nsave = -1;
    static int m;

    double f, f1, f2, u, v, w, w2, x, x1, x2, z, z2;
    double p, q, np, g, r, al, alv, amaxp, ffm, ynorm;
    int i,ix,k, n;

    if (!finite(nin))
    {
     printf("Error 1! Non-finite nin!\n");
     exit(0);
    }
    n = floor(nin + 0.5);
    if (n != nin)
    {
     printf("Error 2! Non-finite nin!\n");
     exit(0);
    }

    if (!finite(pp) || n < 0 || pp < 0. || pp > 1.)          /* n=0, p=0, p=1 are not errors <TSL>*/
    {
     printf("Error! Invalid input parameters to rbinom function!\n");
     exit(0);
    }

    if (n == 0 || pp == 0.) return 0;
    if (pp == 1.) return n;

    p = fmin2(pp, 1. - pp);
    q = 1. - p;
    np = n * p;
    r = p / q;
    g = r * (n + 1);

    /* Setup, perform only when parameters change [using static (globals): */
    if (pp != psave || n != nsave) {
    psave = pp;
    nsave = n;
    if (np < 30.0) {
        /* inverse cdf logic for mean less than 30 */
        qn = pow(q, (double) n);
        goto L_np_small;
    } else {
        ffm = np + p;
        m = ffm;
        fm = m;
        npq = np * q;
        p1 = (int)(2.195 * sqrt(npq) - 4.6 * q) + 0.5;
        xm = fm + 0.5;
        xl = xm - p1;
        xr = xm + p1;
        c = 0.134 + 20.5 / (15.3 + fm);
        al = (ffm - xl) / (ffm - xl * p);
        xll = al * (1.0 + 0.5 * al);
        al = (xr - ffm) / (xr * q);
        xlr = al * (1.0 + 0.5 * al);
        p2 = p1 * (1.0 + c + c);
        p3 = p2 + c / xll;
        p4 = p3 + c / xlr;
    }
    } else if (n == nsave) {
    if (np < 30.0)
        goto L_np_small;
    }

    /*-------------------------- np = n*p >= 30 : ------------------- */
    repeat {
      u = ((double)rand()/RAND_MAX) * p4;
      v = (double)rand()/RAND_MAX;
      /* triangular region */
      if (u <= p1) {
      ix = xm - p1 * v + u;
      goto finis;
      }
      /* parallelogram region */
      if (u <= p2) {
      x = xl + (u - p1) / c;
      v = v * c + 1.0 - fabs(xm - x) / p1;
      if (v > 1.0 || v <= 0.)
          continue;
      ix = x;
      } else {
      if (u > p3) { /* right tail */
          ix = xr - log(v) / xlr;
          if (ix > n)
          continue;
          v = v * (u - p3) * xlr;
      } else {/* left tail */
          ix = xl + log(v) / xll;
          if (ix < 0)
          continue;
          v = v * (u - p2) * xll;
      }
      }
      /* determine appropriate way to perform accept/reject test */
      k = abs(ix - m);
      if (k <= 20 || k >= npq / 2 - 1) {
      /* explicit evaluation */
      f = 1.0;
      if (m < ix) {
          for (i = m + 1; i <= ix; i++)
          f *= (g / i - r);
      } else if (m != ix) {
          for (i = ix + 1; i <= m; i++)
          f /= (g / i - r);
      }
      if (v <= f)
          goto finis;
      } else {
      /* squeezing using upper and lower bounds on log(f(x)) */
      amaxp = (k / npq) * ((k * (k / 3. + 0.625) + 0.1666666666666) / npq + 0.5);
      ynorm = -k * k / (2.0 * npq);
      alv = log(v);
      if (alv < ynorm - amaxp)
          goto finis;
      if (alv <= ynorm + amaxp) {
          /* stirling's formula to machine accuracy */
          /* for the final acceptance/rejection test */
          x1 = ix + 1;
          f1 = fm + 1.0;
          z = n + 1 - fm;
          w = n - ix + 1.0;
          z2 = z * z;
          x2 = x1 * x1;
          f2 = f1 * f1;
          w2 = w * w;
          if (alv <= xm * log(f1 / x1) + (n - m + 0.5) * log(z / w) + (ix - m) * log(w * p / (x1 * q)) + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / f2) / f2) / f2) / f2) / f1 / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / z2) / z2) / z2) / z2) / z / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / x2) / x2) / x2) / x2) / x1 / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / w2) / w2) / w2) / w2) / w / 166320.)
          goto finis;
      }
      }
  }

 L_np_small:
    /*---------------------- np = n*p < 30 : ------------------------- */

  repeat {
     ix = 0;
     f = qn;
     u = (double)rand()/RAND_MAX;
     repeat {
     if (u < f)
         goto finis;
     if (ix > 110)
         break;
     u -= f;
     ix++;
     f *= (g / ix - r);
     }
  }
 finis:
    if (psave > 0.5)
     ix = n - ix;
  return (double)ix;
}                                                               /* End of rbinom function */




/* Function to generate a multinomial random vector. */
void rmultinom(int n, double *prob, int K, int *rN)
{
    int k;
    double pp, p_tot = 0.;

    if (K < 1 || n < 0 ) 
    {
     printf("Error! Incorrect input parameters to function rmultinom!");
     exit(0);
    }

    /* Check that probability vector adds to 1. */
    for(k = 0; k < K; k++) {
    pp = prob[k];
    if (!finite(pp) || pp < 0. || pp > 1.)
    {
     printf("Error! Probabilities are strange for group %d! \t pp =%lf.\n", k, pp);
     exit(0);
    }
    p_tot += pp;
    rN[k] = 0;
    }
    if(fabs(p_tot - 1.) > 1e-7)
    {
     printf("Probability sum should be 1, but is %g.\n",p_tot);
     exit(0);
    }
    if (n == 0) return;
    if (K == 1 && p_tot == 0.) return;  /* trivial border case: do as rbinom */

    /* Generate the first K-1 obs. via binomials */

    for(k = 0; k < K-1; k++) 
    {                                /* (p_tot, n) are for "remaining binomial" */
     if(prob[k])
     {
       pp = prob[k] / p_tot;
       rN[k] = ((pp < 1.) ? (int) rbinom((double) n,  pp) : n);
             /* >= 1; > 1 happens because of rounding */
        n -= rN[k];
    }
    else rN[k] = 0;
    if(n <= 0) /* we have all*/ return;
    p_tot -= prob[k]; /* i.e. = sum(prob[(k+1):K]) */
    }
    rN[K-1] = n;
 return;
}               /* End of function to simulate multinomial variates. */


/* Function to simulate a vector of Dirichlet variates */
void rdirichlet(int vec_length, double *alpha, double *vec)
{
 int k;
 double total = 0;

 for(k=0; k<vec_length; k++)
 {
  vec[k] = rgamma(alpha[k]*1, 1);                 /* Generate a Gamma(alpha[k], 1) */
  total += vec[k];
 }      /* End of k loop */
 for(k=0; k<vec_length; k++)
 {
  vec[k] = vec[k]/total;            /* Dirichlet variate is alpha_k/sum(alpha_k) */
 }          /* End of k loop */
}       /* End of rdirichlet function */

/* Function to return a U[lower,upper] random variate. */
double runif(double lower, double upper)
{
	double u;
 
	u = (double)rand()/RAND_MAX;
	u = lower + (upper - lower)*u;
 	return(u);
}


/* Function to return the maximum of 2 numbers */
double Max2(double x, double y)
{
    return (x > y) ? x : y;
}

/* rtruncn function */
double rtruncn (double mn, double sdev, double lowlim, double uplim)
{
    double A, B, maxA, maxB, maxR, r2, r, th, u, x;
		int accept=0;
    
		double a = (lowlim - mn)/sdev;
		double b = (uplim - mn)/sdev;

    A = atan(a);
    B = atan(b);
    
    maxA = exp(-pow(a,2)/4)/cos(A);
    maxB = exp(-pow(b,2)/4)/cos(B);
    maxR = Max2(maxA, maxB);
	
    if((a<1) && (b>-1)) maxR = exp(-0.25)*sqrt(2.0);
	
    while (accept!=1)
    {
        r2 = runif(0.0,1.0);
        r = sqrt(r2)*maxR;
        th = runif(A,B);
        u = r*cos(th);
        //v = r*sin(th);
        x = tan(th);
        accept = ((pow(x,2)) < (log(u)*-4));
    }
    return (mn + sdev*x);
	
}
