#include<stdio.h>
#include<stdlib.h>
#include<math.h>

#include "Mem.h"
#include "LinAlg.h"
#include "MiscCFuncs.h"


/* Function takes a binary matrix and returns which column of each row is 1. Similar to map in R */
void map(int **Alloc, int nrow, int ncol, double *ind){
	int i, g;

	for(i=0; i<nrow; i++){
		for(g=0; g<ncol; g++){
			if(Alloc[i][g]==1)
				ind[i] = g;
		}	
	}
}

/* Function counts the number of incidents of each number in a list */
void table(double *ind, int MaxInd, int length, double *tab){
	int i, g;
/*	double *tab = OnedDoubleMemAlloc(MaxInd);*/
	for(g=0; g<MaxInd; g++)
		tab[g] = 0;

	for(i=0; i<length; i++){
		for(g=0; g<MaxInd; g++){
			if(ind[i]==g)
				tab[g]++;
		}
	}
/*	return(tab);*/
/*	free(tab);*/
}

/* Function to construct the identity matrix for any given dimension */
double **Identity(int d){
	int i, j;
	double **Id = TwodDoubleMemAlloc(d, d);

	for(i=0; i<d; i++){
		for(j=0; j<d; j++){
			if(i==j){
				Id[i][j] = 1;
			}else{
				Id[i][j] = 0;
			}
		}	
	}
	return(Id);
	freeDoubleMat(Id, d);
}

/* Function extracts row or column "index" from a matrix given a value for "rowcol". */
/*double *RowCol(double **A, int no_rows, int no_cols, int index, int rowcol){*/
/*	int i;*/
/*	double *res;*/

/*	if(rowcol != 1 && rowcol != 2)*/
/*	{*/
/*		printf("Invalid row/column indicator passed!\n");*/
/*		exit;*/
/*	}*/

/*	if(rowcol==1){*/
/*		res = OnedDoubleMemAlloc(no_cols);*/
/*		for(i=0; i<no_cols; i++)*/
/*			res[i] = A[index][i];*/
/*		return(res);*/
/*		free(res);*/
/*	}else{*/
/*		res = OnedDoubleMemAlloc(no_rows);*/
/*		for(i=0; i<no_rows; i++)*/
/*			res[i] = A[i][index];*/
/*		return(res);*/
/*		free(res);*/
/*	}*/
/*}*/

double *RowCol(double **A, int no_rows, int no_cols, int index, int rowcol){
	int i;
	double *res;

	if(rowcol != 1 && rowcol != 2)
	{
		printf("Invalid row/column indicator passed!\n");
	}

	if(rowcol==1){
		return(A[index]);
	}else{
		res = OnedDoubleMemAlloc(no_rows);
		for(i=0; i<no_rows; i++)
			res[i] = A[i][index];
		return(res);
		free(res);
	}
}

/* Function extracts a sheet from a 3D array. */
/*double **Sheet(double ***A, int no_rows, int no_cols, int sheet){*/
/*	int i, j;*/
/*	double **res = TwodDoubleMemAlloc(no_rows, no_cols);*/

/*	//if(rowcol != 1 && rowcol != 2)*/
/*	//{*/
/*	//	printf("Invalid row/column indicator passed!\n");*/
/*	//	exit;*/
/*	//}*/

/*	for(i=0; i<no_rows; i++){*/
/*		for(j=0; j<no_cols; j++)	*/
/*			res[i][j] = A[i][j][sheet];*/
/*	}*/
/*	return(res);*/
/*	freeDoubleMat(res, no_rows);*/
/*}*/

/*Function to decompose a matrix into a vector*/
/*If ind=1 the decomposition is by row, if ind=2 the decomposition is by column*/
void MatDecomp(double **A, int no_rows, int no_cols, double *Res, int ind){
	int i, j;

	if(ind != 1 && ind != 2)
	{
		printf("ind does not take the value 1 or 2!\n");
	}

	if (ind == 1){
		for (i=0; i<no_rows; i++){
			for (j=0; j<no_cols; j++)		
				Res[i*no_cols + j] = A[i][j];
		}
	}else{
		for (j=0; j<no_cols; j++){
			for (i=0; i<no_rows; i++)		
				Res[j*no_rows + i] = A[i][j];
		}
	}
}


/* Function to decompose a 3D array into a matrix where each sheet is decomposed into a row */
/* If ind=1 each sheet is decomposed by row, if ind=2 each sheet is decomposed ny column  */
void ArrayDecomp(double ***A, int no_sheets, int no_rows, int no_cols, double **Res, int ind){
	int g;

	if(ind != 1 && ind != 2)
	{
		printf("ind does not take the value 1 or 2!\n");
	}

	if (ind == 1){
		for(g=0; g<no_sheets; g++){
			MatDecomp(A[g], no_rows, no_cols, Res[g], 1);
		}
	}else{
		for(g=0; g<no_sheets; g++){
			MatDecomp(A[g], no_rows, no_cols, Res[g], 2);
		}
	}
}

/* Function to recompose a matrix from a vector*/
/*If ind=1 the matrix is filled by row, if ind=2 the matrix is filled by column*/
void MatRecomp(double *a, int no_rows, int no_cols, double **Res, int ind){
	int i, j;

	if(ind != 1 && ind != 2)
	{
		printf("ind does not take the value 1 or 2!\n");
	}

	if (ind == 1){
		for (i=0; i<no_rows; i++){
			for (j=0; j<no_cols; j++)		
				Res[i][j] = a[i*no_rows + j];
		}
	}else{
		for (j=0; j<no_cols; j++){
			for (i=0; i<no_rows; i++)		
				Res[i][j] = a[j*no_cols + i];
		}
	}
}

/* Function to find the maximum element of a vector */
double max(double *vec, int lengthVec){
	int i;
	double max= -HUGE_VAL;	

	for(i=0; i<lengthVec; i++)
		if(vec[i] > max){max = vec[i];}

return(max);
}

/* Function to find the minimum element of a vector */
double min(double *vec, int lengthVec){
	int i;
	double min= HUGE_VAL;	

	for(i=0; i<lengthVec; i++)
		if(vec[i] < min){min = vec[i];}

return(min);
}

/* Function which returns the sum of the entries in a vector */
double sum(double *vec, int vec_length){
	int i;
	double vec_sum = 0.0;

	for(i=0; i<vec_length; i++)
		vec_sum += vec[i];

	return(vec_sum);
}

/* Function which returns the product of the entries in a vector */
double prod(double *vec, int vec_length){
	int i;
	double vec_prod = 1;

	for(i=0; i<vec_length; i++)
		vec_prod *= vec[i];

	return(vec_prod);
}

/* Function to print a vector (ints) to screen */
void IntVec2Screen(int *Vec, int length){
	int i;
	for(i=0; i<length; i++){
			printf("[%d] \t %d \n", i, Vec[i]);	
	}
	printf("\n");	
}

/* Function to print a vector (doubles) to screen */
void DoubleVec2Screen(double *Vec, int length){
	int i;
	for(i=0; i<length; i++){
			printf("[%d] \t %lf \n", i, Vec[i]);	
	}
	printf("\n");	
}

/* Function to print a matrix (ints) to screen */
void IntMat2Screen(int **Mat, int nrow, int ncol){
	int i, j;
	for(i=0; i<nrow; i++){
		for(j=0; j<ncol; j++){
			printf("%d \t", Mat[i][j]);	
		}
		printf("\n");	
	}
}

/* Function to print a matrix (doubles) to screen */
void DoubleMat2Screen(double **Mat, int nrow, int ncol){
	int i, j;
	for(i=0; i<nrow; i++){
		for(j=0; j<ncol; j++){
			printf("%lf \t", Mat[i][j]);	
		}
		printf("\n");	
	}
}

/* apply function as in R, only functions which take a double * and int can be applied*/
double *apply(double **Mat, int nrow, int ncol, int rowcol, double (*foo)(double *, int)){
	int i;
	
	if((rowcol!=1)&&(rowcol!=2)) printf("Incorrect 'rowcol' value specified");

	if(rowcol==1){
		double *ptr = OnedDoubleMemAlloc(nrow);
		for(i=0; i<nrow; i++){
			ptr[i] = foo(Mat[i], ncol);
		}
		return(ptr);
		free(ptr);
	}else{
		double *ptr = OnedDoubleMemAlloc(ncol);
		double **TMat = MatTrans(Mat, nrow, ncol);
		for(i=0; i<ncol; i++){
			ptr[i] = foo(TMat[i], nrow);
		}
		freeDoubleMat(TMat, ncol);
		return(ptr);
		free(ptr);
	}
}

/* Function to count the number of TRUEs in a boolean (int in C) vector*/
int sumBin(int *vec, int length){
	int i;
	int c=0;	
	for(i=0; i<length; i++){
		if(vec[i]==1) c++;
	} // i
	return(c);
}

/* Function to return a subvector containing the entries of the original as dictated by a boolean (int in C) vector*/
double *SubVec(double *a, int la, int *vec){
	int i;	
	int new_l=sumBin(vec, la);

	double *new_a = OnedDoubleMemAlloc(new_l);
	int c=0;
	for(i=0; i<la; i++){
		if(vec[i]==1){
			new_a[c] = a[i];
			c++;
		} //if
	} //i
	return(new_a);
	free(new_a);
}

/* Function to return a submatrix containing the rows/columns of the original as dictated by a boolean (int in C) vector*/
/*double **SubMat(double **Mat, int nrow, int ncol, int *vec, int rowcol){*/
/*	int i, j;*/

/*	if((rowcol!=1)&&(rowcol!=2)) printf("Incorrect 'rowcol' value specified");*/

/*	if(rowcol==1){*/
/*		int new_n = sumBin(vec, nrow);*/
/*		double **newMat = TwodDoubleMemAlloc(new_n, ncol);*/
/*		int c = 0;*/
/*		for(i=0; i<nrow; i++){*/
/*			if(vec[i]==1){*/
/*				for(j=0; j<ncol; j++)*/
/*					newMat[c][j] = Mat[i][j];*/
/*				c++;*/
/*			} // if*/
/*		} // i*/
/*		return(newMat);*/
/*		freeDoubleMat(newMat, new_n);*/
/*	}else{*/
/*		int new_n = sumBin(vec, ncol);*/
/*		double **newMat = TwodDoubleMemAlloc(nrow, new_n);*/
/*		int c = 0;*/
/*		for(j=0; j<ncol; j++){*/
/*			if(vec[j]==1){*/
/*				for(i=0; i<nrow; i++)*/
/*					newMat[i][c] = Mat[i][j];*/
/*				c++;*/
/*			} // if*/
/*		} // i*/
/*		return(newMat);*/
/*		freeDoubleMat(newMat, new_n);*/
/*	}*/
/*}*/

/* Function to return a submatrix containing the rows/columns of the original as dictated by a boolean (int in C) vector*/
void SubMat(double **Mat, int nrow, int ncol, int *vec, int rowcol, double **Sub, int sub_r, int sub_c){
	int i, j;

	if((rowcol!=1)&&(rowcol!=2)) printf("Incorrect 'rowcol' value specified");

	if(rowcol==1){
		int new_n = sumBin(vec, nrow);

		if((new_n!=sub_r)||(ncol!=sub_c))
			printf("Matrix provided has incorrect dimensions");

		int c = 0;
		for(i=0; i<nrow; i++){
			if(vec[i]==1){
				for(j=0; j<ncol; j++)
					Sub[c][j] = Mat[i][j];
				c++;
			} // if
		} // i
	}else{
		int new_n = sumBin(vec, ncol);

		if((nrow!=sub_r)||(new_n!=sub_c))
			printf("Matrix provided has incorrect dimensions");

		int c = 0;
		for(j=0; j<ncol; j++){
			if(vec[j]==1){
				for(i=0; i<nrow; i++)
					Sub[i][c] = Mat[i][j];
				c++;
			} // if
		} // i
	}
}

/* Function to return a copy of a vector of ints */
void IntVecCopy(int *vec, int length, int *vec_copy){
	int i;

	for(i=0; i<length; i++){
			vec_copy[i] = vec[i];
	}// i
}


/* Function to return a copy of a vector of doubles */
void DoubleVecCopy(double *vec, int length, double *vec_copy){
	int i;

	for(i=0; i<length; i++){
			vec_copy[i] = vec[i];
	}// i
}

/* Function to return a copy of a vector of doubles */
void CharVecCopy(char *vec, int length, char *vec_copy){
	int i;

	for(i=0; i<length; i++){
			vec_copy[i] = vec[i];
	}// i
}

/* Function to return a copy of a matrix of doubles */
void DoubleMatCopy(double **Y, int nrow, int ncol, double **Y_copy){
	int i, j;

	for(i=0; i<nrow; i++){
		for(j=0; j<ncol; j++){
			Y_copy[i][j] = Y[i][j];
		}// j	
	}// i
}

/* Function to return a copy of a matrix of ints */
void IntMatCopy(int **Y, int nrow, int ncol, int **Y_copy){
	int i, j;

	for(i=0; i<nrow; i++){
		for(j=0; j<ncol; j++){
			Y_copy[i][j] = Y[i][j];
		}// j	
	}// i
}

/* Function which takes a vector log(x) and returns log(sum(x)) */
double logsum(double *log_vec, int lvec){
	int j;
	double maxl = max(log_vec, lvec);
	double tempsum = 0;

	for(j=0; j<lvec; j++){
		if(log_vec[j]!=maxl)
			tempsum += exp(log_vec[j] - maxl);
	}
	
	double log_sum = maxl + log(1 + tempsum);
	return(log_sum);
}
