struct indices
{
	int N, J, D, Q, G, CnsIndx, OrdIndx, nNom, nOrd;
	double *Knom, *Kord;
	int *nom_J, *nom_D;
};

struct params
{
	double ***lambda;
	double ***A;
	double ***Mu;
	double **Y;
	double **Z;
	double **theta;
	double **theta_til;
	int **Alloc;
	double *pi_vec;
	double *ind;
	double *ng;
	double **inv_psi;
};

struct priors
{
	double *alpha;
	double beta1;
	double beta2;
	double **invSig_lam;
	double *mu_lam;
};

struct variableSelect
{
	double *VarProp_J;
	double *VarProp_D;
	int *keep_J;
	int *keep_D;
};

void allocate_indices(struct indices *indx);
void free_indices(struct indices *indx);
void allocate_params(struct params *temp, int G, int D, int Q, int N, int J);
void free_params(struct params *temp, int G, int D, int Q, int N, int J);
void copy_params(struct params *temp, struct params *temp_copy, int G, int D, int Q, int N, int J);
void allocate_priors(struct priors *temp, int G, int Q);
void free_priors(struct priors *temp, int Q);
void allocate_variableSelect(struct variableSelect *temp, int J, int D);
void free_variableSelect(struct variableSelect *temp);
