#include<stdio.h>
#include<stdlib.h>
#include "Mem.h"
#include "MiscCFuncs.h"
#include "MFAMD_structs.h"

void allocate_indices(struct indices *indx){
	indx->nNom = indx->J - indx->OrdIndx;
	indx->nOrd = (indx->OrdIndx - indx->CnsIndx);
	indx->Kord = OnedDoubleMemAlloc(indx->nOrd);
	indx->Knom = OnedDoubleMemAlloc(indx->nNom);
	indx->nom_D = OnedIntMemAlloc(indx->nNom);
	indx->nom_J = OnedIntMemAlloc(indx->nNom);
}

void free_indices(struct indices *indx){
	free(indx->Kord);
	free(indx->Knom);
	free(indx->nom_D);
	free(indx->nom_J);
}

void allocate_params(struct params *temp, int G, int D, int Q, int N, int J){
	temp->lambda = ThreedDoubleMemAlloc(G, D, (Q+1));
	temp->A = ThreedDoubleMemAlloc(G, D, Q);
	temp->Mu = ThreedDoubleMemAlloc(G, N, D);
	temp->Y = TwodDoubleMemAlloc(N, J);
	temp->Z = TwodDoubleMemAlloc(N, D);
	temp->theta = TwodDoubleMemAlloc(N, Q);
	temp->theta_til = TwodDoubleMemAlloc(N, (Q+1));
	temp->Alloc = TwodIntMemAlloc(N, G);
	temp->pi_vec = OnedDoubleMemAlloc(G);
	temp->ind = OnedDoubleMemAlloc(N);
	temp->ng = OnedDoubleMemAlloc(G);
	temp->inv_psi = TwodDoubleMemAlloc(D, D);
}

void free_params(struct params *temp, int G, int D, int Q, int N, int J){
	freeDoubleArray3d(temp->lambda, G, D);
	freeDoubleArray3d(temp->A, G, D);	
	freeDoubleArray3d(temp->Mu, G, N);
	freeDoubleMat(temp->Y, N);
	freeDoubleMat(temp->Z, N);
	freeDoubleMat(temp->theta, N);
	freeDoubleMat(temp->theta_til, N);
	freeIntMat(temp->Alloc, N);
	free(temp->pi_vec);
	free(temp->ind);
	free(temp->ng);
	freeDoubleMat(temp->inv_psi, D);
}

void copy_params(struct params *temp, struct params *temp_copy, int G, int D, int Q, int N, int J){
	int g;
	for (g=0; g<G; g++){
		DoubleMatCopy(temp->lambda[g], D, Q+1, temp_copy->lambda[g]);
		DoubleMatCopy(temp->A[g], D, Q, temp_copy->A[g]);
		DoubleMatCopy(temp->Mu[g], N, D, temp_copy->Mu[g]);
	}// g
	DoubleMatCopy(temp->Y, N, J, temp_copy->Y);
	DoubleMatCopy(temp->Z, N, D, temp_copy->Z);
	DoubleMatCopy(temp->theta, N, Q, temp_copy->theta);
	DoubleMatCopy(temp->theta_til, N, Q+1, temp_copy->theta_til);
	IntMatCopy(temp->Alloc, N, G, temp_copy->Alloc);
	DoubleVecCopy(temp->pi_vec, G, temp_copy->pi_vec);
	DoubleVecCopy(temp->ind, N, temp_copy->ind);
	DoubleVecCopy(temp->ng, G, temp_copy->ng);	
	DoubleMatCopy(temp->inv_psi, D, D, temp_copy->inv_psi);
}

void allocate_priors(struct priors *temp, int G, int Q){
	temp->alpha = OnedDoubleMemAlloc(G);
	temp->mu_lam = OnedDoubleMemAlloc((Q+1));
}

void free_priors(struct priors *temp, int Q){
	free(temp->alpha);
	freeDoubleMat(temp->invSig_lam, Q+1);
	free(temp->mu_lam);
}

void allocate_variableSelect(struct variableSelect *temp, int J, int D){
	temp->VarProp_J = OnedDoubleMemAlloc(J);
	temp->VarProp_D = OnedDoubleMemAlloc(D);
	temp->keep_J = OnedIntMemAlloc(J);
	temp->keep_D = OnedIntMemAlloc(D);
}

void free_variableSelect(struct variableSelect *temp){
	free(temp->VarProp_J);
	free(temp->VarProp_D);
	free(temp->keep_J);
	free(temp->keep_D);
}
