#include<stdio.h>
#include<strings.h>
#include<stdlib.h>
#include<math.h>
#include<time.h>
#include<gsl/gsl_randist.h>
#include<gsl/gsl_cdf.h>

#include "Mem.h"
#include "FileOps.h"
#include "LinAlg.h"
#include "rangen.h"
#include "RandVarSim.h"
#include "MiscCFuncs.h"
#include "MFAMD_structs.h"
#include "MFAMD_Funcs.h"
#include "StatsBase.h"

int main(){

	int i, j, g, d, iter;

	//////////////
	// Controls //
	//////////////
	int Burnin = 5000;
	int Thin = 50;
	int MaxIter=25000;
	int Verb = 100;
	int VarSelIter = 1;
	int VarSelOft = 1;
	double PropTol_cns = 0.95;
	double PropTol_cat = 0.99;
	int Jequal = 4;

	///////////////////
	// Model indices //
	///////////////////
	int N = 500;
	int J = 738;
	int D = 1079; //could automate this
	int Q = 2;
	int G = 4;
	int CnsIndx = 26;
	int OrdIndx = 397;

	///////////////////
	// Initial values//
	///////////////////

	// Variable names and reference numbers
	int *VarNums = OnedIntMemAlloc(J);
	for(j=0; j<J; j++) VarNums[j] = (j+1); // actual column numbers

	// List of parameters, see MFAMD_strucs.h
	struct params parameters, *pars;
	pars = &parameters;
	allocate_params(pars, G, D, Q, N, J);

	ReadDataMat("Input/Y.txt", N, J, pars->Y);
	ReadDataMat("Input/Z.txt", N, D, pars->Z);		
	ReadDataMat("Input/theta.txt", N, Q, pars->theta);
	for(i=0; i<N; i++){
		pars->theta_til[i][0] = 1;
		for(j=0; j<Q; j++)
			pars->theta_til[i][j+1] = pars->theta[i][j];	
	}

	double **Iq = Identity(Q);
	double **Id = Identity(D);
	ReadDataMat("Input/InvPsi.txt", D, D, pars->inv_psi);
	//double **inv_psi = Identity(D);
	ReadDataVec("Input/pi.txt", G, pars->pi_vec);
	ReadDataVec("Input/ind.txt", N, pars->ind);
	ReadDataVec("Input/ng.txt", G, pars->ng);
	FILE* fp; 
	fp=fopen("Input/lambda.txt", "r");
	for (g=0; g<G; g++){ 
		for (i=0; i<D; i++){ 
			for (j=0; j<(Q+1); j++)
					fscanf(fp, "%lf", &pars->lambda[g][i][j]);
		} 
	}
	fclose(fp);

	for (g=0; g<G; g++){
		for(d=0; d<D; d++){
			for (j=1; j<(Q+1); j++)
				pars->A[g][d][j-1] = pars->lambda[g][d][j];
		}
	}

	////////////////////////
	// Indexing Constants //
	////////////////////////

	int nOrd = (OrdIndx-CnsIndx);
	double *Kord = OnedDoubleMemAlloc(nOrd);
	int maxKord = 0;
	if(nOrd > 0){
		for(j=CnsIndx; j<OrdIndx; j++){
			double *Ycol_j=RowCol(pars->Y, N, J, j, 2);
			Kord[j-CnsIndx] = max(Ycol_j, N);
			free(Ycol_j);
		}
		maxKord = (int)max(Kord, nOrd);
	}

	//Initial values of threshold parameters
	double **GamMat = TwodDoubleMemAlloc(OrdIndx, maxKord+1);
	
	if(nOrd > 0){
		ReadDataMat("Input/Gamma.txt", OrdIndx, maxKord+1, GamMat);

		for(j=CnsIndx; j<OrdIndx; j++){
			GamMat[j][0] = -HUGE_VAL;
			GamMat[j][(int)Kord[j-CnsIndx]] = HUGE_VAL;
		}
		DoubleMatToFile(GamMat, OrdIndx, maxKord+1, "Output/GamMat.txt");	
	}

	int nNom = J - OrdIndx;
	double *Knom = OnedDoubleMemAlloc(nNom);
	int *nom_D = OnedIntMemAlloc(nNom);
	int *nom_J = OnedIntMemAlloc(nNom);
	if(nNom>0){

		for(j=OrdIndx; j<J; j++){
			double *Ycol_j = RowCol(pars->Y, N, J, j, 2);
			Knom[j-OrdIndx] = max(Ycol_j, N);
			free(Ycol_j);
			printf("Knom %d %lf \n", j-OrdIndx, Knom[j-OrdIndx]);
		}

		for(j=OrdIndx; j<J; j++)
			nom_J[j-OrdIndx] = j;

		double Knom_sum = 0;
		for(d=0; d<nNom; d++){
			if(d>0){
				Knom_sum += Knom[d-1];
				nom_D[d] = (int)(OrdIndx + Knom_sum -d);
			}else{
				nom_D[d] = (int)OrdIndx;
			}
		}
	}//if


	//////////////////////
	// Prior parameters //
	//////////////////////
	struct priors prs, *prior;
	prior = &prs;
	allocate_priors(prior, G, Q);

	// Dirichlet prior for mixing weights
	for(g=0; g<G; g++){
		prior->alpha[g] = 40;
	}

	// Inverse gamma prior for psi
	prior->beta1 = 7;
	prior->beta2 = 7;
	
	// Normal prior for loadings	
	double **Iqplus1 = Identity((Q+1));
	prior->invSig_lam = DoubleScalarMatMul(Iqplus1, (Q+1), (Q+1), 0.2);
	freeDoubleMat(Iqplus1, (Q+1));

	for(i=0; i<(Q+1); i++)
		prior->mu_lam[i] = 0.0;
		
	// Metropolis hastings parameters
	double *sig_MH;
	int *MHcount;
	if(nOrd > 0){
		sig_MH = OnedDoubleMemAlloc(nOrd);
		for(j=0; j<nOrd; j++){
			sig_MH[j] = 0.02;
		}

		MHcount = OnedIntMemAlloc(nOrd);
		for(j=0; j<nOrd; j++)
			MHcount[j]=0;
	}

	//////////////////////
	//		Burnin loop		//
	//////////////////////
	
	for(iter=0; iter<Burnin; iter++){
		if((iter%Verb)==0){printf("Burn %d \n", iter);}

		SampleParameters(G, D, Q, N, CnsIndx, OrdIndx, nOrd, Kord, Knom, sig_MH, MHcount, GamMat, Iq, nNom, nom_D, nom_J, pars, prior);

	} // iter

	IntMatToFile(pars->Alloc, N, G, "Output/IndBurn.txt");

	////////////////////////
	// Variable Selection //
	////////////////////////

	FILE *VarsRm = fopen("Output/VarsRm.txt", "w");
	FILE *Jfile = fopen("Output/Jfile.txt", "w");
	fprintf(Jfile, "%d \n", J);

	if(G>1){
		struct variableSelect variSel, *varSelect;
		varSelect = &variSel;

		// Store previous J's for stopping criterion
		double *Jstore = OnedDoubleMemAlloc(Jequal);
		int Jcount = 0;
		double Jmax, Jmin;

		for(iter=0; iter<VarSelIter; iter++){
			if((iter%Verb)==0){printf("VarSel %d \n", iter);}
		
			SampleParameters(G, D, Q, N, CnsIndx, OrdIndx, nOrd, Kord, Knom, sig_MH, MHcount, GamMat, Iq, nNom, nom_D, nom_J, pars, prior);
		
			if(!(iter%VarSelOft)){
				printf("J is %d \n", J);
				allocate_variableSelect(varSelect, J, D);
				VarSel(G, D, N, CnsIndx, OrdIndx, PropTol_cns, PropTol_cat, J, Knom, nom_D, pars, varSelect);

				//Write name(s) and number(s) of removed variables to file
				for(j=0; j<J; j++)
					if(!varSelect->keep_J[j]) fprintf(VarsRm, "%d \n", VarNums[j]);

				VarClean(&G, &Q, &N, &J, &D, &CnsIndx, &OrdIndx, &nOrd, &nNom, &maxKord, &Kord, &Knom, &nom_D, &nom_J, &GamMat, &Id, &VarNums, pars,  varSelect);		

				// Record new value of J
				fprintf(Jfile, "%d \n", J);

				Jstore[Jcount%Jequal] = J;
				Jcount++;

				free_variableSelect(varSelect);
				Jmax = max(Jstore, Jequal);
				Jmin = min(Jstore, Jequal);
			}
			// Stop variable selection if J unchanging.
			if(Jmax==Jmin) break;
		} // iter
		free(Jstore);
	} // if G > 1
	fclose(VarsRm);
	fclose(Jfile);

	// Write names and column numbers of retained variables to file
	FILE *VarsRetained = fopen("Output/VarsRetained.txt", "w");
	for(j=0; j<J; j++) fprintf(VarsRetained, "%d \n", VarNums[j]);
	fclose(VarsRetained);
	
	// Write indices to file
	FILE *FinalIndices = fopen("Output/FinalIndices.txt", "w");
	fprintf(FinalIndices, "N \t %d \n J \t %d \n D \t %d \n Q \t %d \n G \t %d \n CnsIndx \t %d \n OrdIndx \t %d \n", N, J, D, Q, G, CnsIndx, OrdIndx);
	fclose(FinalIndices);

	//////////////////////
	//	Sampling loop		//
	//////////////////////

	// Open files to store sampled parameter values
	FILE *thetaFile = fopen("Output/thetaNew.txt", "w");
	FILE *piFile = fopen("Output/piNew.txt", "w");
	FILE *indFile = fopen("Output/indNew.txt", "w");
	FILE *ngFile = fopen("Output/ngNew.txt", "w");
	FILE *lambdaFile = fopen("Output/lambdaNew.txt", "w");
	FILE *GamFile = fopen("Output/GamNew.txt", "w");
	FILE *ZFile = fopen("Output/ZNew.txt", "w");
	FILE *invPsiFile = fopen("Output/invPsiNew.txt", "w");
	FILE *ZbarFile = fopen("Output/ZbarStore.txt", "w");

	// Initialise running mean of sampled Z matrices
	double **Z_mean = TwodDoubleMemAlloc(N, D);
	for(i=0; i<N; i++){
		for(d=0; d<D; d++)
			Z_mean[i][d] = 0;
	}
	double s=0;

	// Reset Metropolis Hastings acceptance counter
	for(j=0; j<nOrd; j++)
		MHcount[j]=0;

	for(iter=0; iter<MaxIter; iter++){
		if((iter%Verb)==0){printf("Sample %d \n", iter);}
		//printf("%d \n", iter);
	
		SampleParameters(G, D, Q, N, CnsIndx, OrdIndx, nOrd, Kord, Knom, sig_MH, MHcount, GamMat, Iq, nNom, nom_D, nom_J, pars, prior);		

		fseek( ZFile , 0 , SEEK_SET );
		DoubleMatToOpenFile(pars->Z, N, D, ZFile);

		if((iter % Thin)==0){
			double **Zmean1 = DoubleScalarMatMul(Z_mean, N, D, s);
			freeDoubleMat(Z_mean, N);
			double **Zmean2 = DoubleMatAdd(Zmean1, N, D, pars->Z, N, D);
			Z_mean = DoubleScalarMatMul(Zmean2, N, D, (1/(s+1)));
			s++;
			freeDoubleMat(Zmean1, N);
			freeDoubleMat(Zmean2, N);

			double *Zbar_store = OnedDoubleMemAlloc(D);
			for(d=0; d<D; d++){
				double *Z_d = RowCol(pars->Z, N, D, d, 2);
				double Z_dsum = sum(Z_d, N);
				Zbar_store[d] = Z_dsum/N;
				free(Z_d);
			}
			
			// Storage for decomposed lambda array
			double **LamDecomp = TwodDoubleMemAlloc(G, (D*(Q+1)));
			ArrayDecomp(pars->lambda, G, D, (Q+1), LamDecomp, 1);

			double *inv_psi_store = OnedDoubleMemAlloc(CnsIndx);
			for(j=0; j<CnsIndx; j++)
				inv_psi_store[j] = pars->inv_psi[j][j];

			DoubleMatToOpenFile(pars->theta, N, Q, thetaFile);
			DoubleVecToOpenFile(pars->pi_vec, G, piFile);
			DoubleVecToOpenFile(pars->ind, N, indFile);
			DoubleVecToOpenFile(pars->ng, G, ngFile);
			DoubleMatToOpenFile(LamDecomp, G, D*(Q+1), lambdaFile);
			//DoubleMatToOpenFile(pars->Z, N, D, ZFile);
			if(OrdIndx!=CnsIndx)	DoubleMatToOpenFile(GamMat, OrdIndx, maxKord+1, GamFile);
			DoubleVecToOpenFile(inv_psi_store, CnsIndx, invPsiFile);
			DoubleVecToOpenFile(Zbar_store, D, ZbarFile);

			free(Zbar_store);
			free(inv_psi_store);
			freeDoubleMat(LamDecomp, G);
		} // if	
	} //iter
	
	// Close Output files
	fclose(thetaFile);
	fclose(piFile);
	fclose(indFile);
	fclose(ngFile);
	fclose(lambdaFile);
	fclose(GamFile);
	fclose(ZFile);
	fclose(invPsiFile);
	fclose(ZbarFile);

	// Write posterior mean and last sampled Z to file
	DoubleMatToFile(Z_mean, N, D, "Output/Z_mean.txt");
	DoubleMatToFile(pars->Z, N, D, "Output/Zlast.txt");
	DoubleMatToFile(pars->Y, N, J, "Output/Y_last.txt");
	
	// Print Metropolis Hastings acceptance counter to screen if applicable
	if(nOrd > 0){
		for(j=0; j<nOrd; j++){
			if(Kord[j]>2)
				printf("%d \n", MHcount[j]);
		} // j
	}

	free_params(pars, G, D, Q, N, J);
	free_priors(prior, Q);
	free(VarNums);
	free(Kord);
	freeDoubleMat(Id, D);
	freeDoubleMat(Iq, Q);
	if(nOrd > 0){
		free(MHcount);
		free(sig_MH);
	}
	free(Knom);
	free(nom_D);
	free(nom_J);

	freeDoubleMat(GamMat, OrdIndx);	
/*	if(OrdIndx>0){*/
/*		freeDoubleMat(GamMat, OrdIndx);*/
/*	}else{*/
/*		freeDoubleMat(GamMat, 1);*/
/*	}*/

	freeDoubleMat(Z_mean, N);
	printf("done \n");
	return(0);
}
