# rm(list=ls())

library(magic)
library(msm)
library(MASS)
library(mclust)
library(e1071)
library(mvtnorm)
library(tmvtnorm)
library(bayesm)
library(MCMCpack)

## Mode Function
modal.value = function(x){
  s = 0
  r = 0
  mde = 0
  x = sort(x)
  y = unique(x)
  
  for(i in 1:length(y)){
    s = length(which(x==y[i]))
    if(s>r){
      mde = y[i]
      r = s
    }else if(s==r){
      mde = c(mde, y[i])   
    }   
  }   
    mde = min(mde)
mde
}


##################
## Load in Data ##
##################

Y <- read.table("Input/Y.txt")

# Theta
theta_temp <- read.table("thetaNew.txt")
theta_temp <- as.matrix(theta_temp)

indices <- read.table("FinalIndices.txt")

N <- indices[1, 2]
J <- indices[2, 2]
D <- indices[3, 2]
Q <- indices[4, 2]
G <- indices[5, 2]
CnsIndx <- indices[6, 2]
OrdIndx <- indices[7, 2]

MaxIter <- nrow(theta_temp)/N

theta_store <- array(NA, c(N, Q, MaxIter))
for(i in 1:MaxIter){
	theta_store[, , i] <- theta_temp[(N*(i-1) +1):(N*i), ]
}

### --------------------------------------- ###

# Pi
pi_temp <- read.table("piNew.txt")
pi_temp <- as.matrix(pi_temp)
pi_store <- matrix(NA, MaxIter, G)

for(i in 1:MaxIter){
	pi_store[i, ] <- pi_temp[(G*(i-1) +1):(G*i), ]
}

### --------------------------------------- ###

# ind
ind_temp <- read.table("indNew.txt")
ind_temp <- as.matrix(ind_temp)
ind_store <- matrix(NA, N, MaxIter)

for(i in 1:MaxIter){
	ind_store[, i] <- ind_temp[(N*(i-1) +1):(N*i), ]
}
ind_store <- ind_store + 1 # Correct C indexing

clus <- NULL
for (i in 1:N){
  clus[i] <- modal.value(ind_store[i, ])
}

### --------------------------------------- ###

# ng
ng_temp <- read.table("ngNew.txt")
ng_store <- matrix(NA, MaxIter, G)

for(i in 1:MaxIter){
	ng_store[i, ] <- ng_temp[(G*(i-1) +1):(G*i), ]
}

### --------------------------------------- ###

# Lambda
lambda_temp <- read.table("lambdaNew.txt")
lambda_temp <- as.matrix(lambda_temp)

lambda_store <- array(NA, c(D, (Q+1), G, MaxIter))
for(i in 1:MaxIter){
	for(g in 1:G){
		lambda_store[,,g,i] <- matrix(lambda_temp[G*(i-1)+g, ], D, (Q+1), byrow=TRUE)

	}
}

### --------------------------------------- ###

## Z
#Z_temp <- read.table(paste(path,"/ZNew.txt", sep=""))
#Z_temp <- as.matrix(Z_temp)

#Z_store <- array(NA, c(N, D, MaxIter))

#for(i in 1:MaxIter){
#	Z_store[, , i] <- Z_temp[(N*(i-1) +1):(N*i), ]
#}

### --------------------------------------- ###
if(OrdIndx!=CnsIndx){
  # Gamma
  Gam_temp <- read.table("GamNew.txt")
  Gam_temp <- as.matrix(Gam_temp)
  
  Gam_store <- array(NA, c(OrdIndx, 3, MaxIter))
  
  for(i in 1:MaxIter){
  	Gam_store[, , i] <- Gam_temp[(OrdIndx*(i-1) +1):(OrdIndx*i), ]
  }
}
### --------------------------------------- ###

if(CnsIndx > 0){
  # Psi
  InvPsi_temp <- read.table("invPsiNew.txt")
  InvPsi_temp <- as.matrix(InvPsi_temp)
  
  InvPsi_store <- matrix(InvPsi_temp, CnsIndx , MaxIter)
  
  # for(i in 1:MaxIter){
  # 	InvPsi_store[, i] <- InvPsi_temp[(2*(i-1) +1):(2*i), 1]
  # }
}

### --------------------------------------- ###

# Log Likelihood
# LogLike <- read.table("Output/LL.txt")
# LogLike <- as.matrix(LogLike)

### --------------------------------------- ###

# remove temporary storage
rm(ind_temp, lambda_temp, ng_temp, pi_temp, theta_temp)
if(OrdIndx!=CnsIndx) rm(Gam_temp)
gc()




### posterior means
if(CnsIndx>0)
  inv.psi.mean <- apply(InvPsi_store, 1, mean)

pi.mean <- apply(pi_store, 2, mean)
lambda.post <- apply(lambda_store, c(1, 2, 3), mean)

theta.clus <- theta_store
for(iter in 1:(MaxIter)){
  theta.clus[ind_store[, iter]!=clus, , iter] <- 0
}
theta.mean <- sweep(apply(theta.clus, c(1, 2), sum), 1, apply(ind_store==clus, 1, sum), "/")

apply(ind_store==clus, 1, sum), "/")

### Variable Selection
if(G > 1){
  VarsRm_num <- read.table("VarsRm.txt")[,1]
  VarsRm_names <- colnames(Y)[VarsRm_num]
}

VarsRet_num <- read.table("VarsRetained.txt")[,1]
VarsRet_names <- colnames(Y)[VarsRet_num]

Jstore <- read.table("Jfile.txt")[,1]

Ynew <- Y[, VarsRet_num]
colnames(Ynew) <- VarsRet_names
Ynew <- as.matrix(Ynew)


