/* 		Some functions for various file operations (be careful of data types) 		*/

#include<stdio.h>
#include<stdlib.h>

/* Funciton to read vector of data (doubles) from a file and store in a vector */
void ReadDataVec(char fn[], int length, double *DataVec){  
  int i; 
  FILE* fp; 
 
  fp=fopen(fn, "r"); 
  for(i=0; i<length; i++)
		fscanf(fp, "%lf", &DataVec[i]);

  fclose(fp);
}

/* Funciton to read vector of data (doubles) from a file and store in a vector */
void ReadStringVec(char fn[], int length, char **StringVec){  
  int i; 
  FILE* fp; 
 
  fp=fopen(fn, "r"); 
  for(i=0; i<length; i++)
		fscanf(fp, "%s", &(*StringVec[i]));

  fclose(fp);
}

/* Funciton to read data (doubles) from a file and store in a matrix */
void ReadDataMat(char fn[], int no_obs, int no_items, double **DataMat){  
  int i, j; 
  FILE* fp; 
 
  fp=fopen(fn, "r"); 
  for (i=0; i<no_obs; i++){ 
		for (j=0; j<no_items; j++)
    		fscanf(fp, "%lf", &DataMat[i][j]);
	} 
  fclose(fp);
}

/* Function to write a matrix (integers) to a file*/
void IntMatToFile(int **Res, int no_rows, int no_cols, char fn[]){
	int i, j;
	FILE *results;

	results = fopen(fn, "w");
 	if(results == NULL)
 	{
  		printf("Error opening file containing matrix of results for writing!\n");
  		exit(0);
 	}

	for(i=0; i<no_rows; i++)
	{
	 	for(j=0; j<no_cols; j++)
	 	{
		 	fprintf(results, "%d", Res[i][j]);
		 	fprintf(results, "%c", '\t');
		}  
		fprintf(results, "%c", '\n');
	}  
  fclose(results);
}

/* Function to write a matrix (integers) to an open file*/
void IntMatToOpenFile(int **Res, int no_rows, int no_cols, FILE *results){
	int i, j;
	
 	if(results == NULL)
 	{
  		printf("Error opening file containing matrix of results for writing!\n");
  		exit(0);
 	}

	for(i=0; i<no_rows; i++)
	{
	 	for(j=0; j<no_cols; j++)
	 	{
		 	fprintf(results, "%d", Res[i][j]);
		 	fprintf(results, "%c", '\t');
		}  
		fprintf(results, "%c", '\n');
	}  
}

/* Function to write a matrix (doubles) to a file*/
void DoubleMatToFile(double **Res, int no_rows, int no_cols, char fn[]){
	int i, j;
	FILE *results;

	results = fopen(fn, "w");
 	if(results == NULL)
 	{
  		printf("Error opening file containing matrix of results for writing!\n");
  		exit(0);
 	}

	for(i=0; i<no_rows; i++)
	{
	 	for(j=0; j<no_cols; j++)
	 	{
		 	fprintf(results, "%.12lf", Res[i][j]);
		 	fprintf(results, "%c", '\t');
		}  
		fprintf(results, "%c", '\n');
	}  
  fclose(results);
}

/* Function to write a matrix (doubles) to an open file*/
void DoubleMatToOpenFile(double **Res, int no_rows, int no_cols, FILE *results){
	int i, j;

 	if(results == NULL)
 	{
  		printf("Error opening file containing matrix of results for writing!\n");
  		exit(0);
 	}

	for(i=0; i<no_rows; i++)
	{
	 	for(j=0; j<no_cols; j++)
	 	{
		 	fprintf(results, "%.12lf", Res[i][j]);
		 	fprintf(results, "%c", '\t');
		}  
		fprintf(results, "%c", '\n');
	}  
}

/* Function to append a matrix to the end of an existing file */
void DoubleMatToFileAPP(double **Res, int no_rows, int no_cols, char fn[]){
	int i, j;
	FILE *results;

	results = fopen(fn, "a+");
 	if(results == NULL)
 	{
  		printf("Error opening file containing matrix of results for writing!\n");
  		exit(0);
 	}

	for(i=0; i<no_rows; i++)
	{
	 	for(j=0; j<no_cols; j++)
	 	{
		 	fprintf(results, "%.12lf", Res[i][j]);
		 	fprintf(results, "%c", '\t');
		}  
		fprintf(results, "%c", '\n');
	}  
  fclose(results);
}

/* Function to write a vector (doubles) to a file */
void DoubleVecToFile(double *Res, int length, char fn[]){
	int i;
	FILE *results;

	results = fopen(fn, "w");
 	if(results == NULL)
 	{
  		printf("Error opening file containing vector of results for writing!\n");
  		exit(0);
 	}

	for(i=0; i<length; i++)
	{
		 	fprintf(results, "%.12lf", Res[i]);
		 	fprintf(results, "%c", '\n');
	}  
  fclose(results);
}

/* Function to write a vector (doubles) to a file */
void DoubleVecToOpenFile(double *Res, int length, FILE *results){
	int i;

 	if(results == NULL)
 	{
  		printf("Error opening file containing vector of results for writing!\n");
  		exit(0);
 	}

	for(i=0; i<length; i++)
	{
		 	fprintf(results, "%.12lf", Res[i]);
		 	fprintf(results, "%c", '\n');
	}  
}


/* Function to append a vector (doubles) to the end of an existing file */
void DoubleVecToFileAPP(double *Res, int length, char fn[]){
	int i;
	FILE *results;

	results = fopen(fn, "a+");
 	if(results == NULL)
 	{
  		printf("Error opening file containing vector of results for writing!\n");
  		exit(0);
 	}

	for(i=0; i<length; i++)
	{
		 	fprintf(results, "%.12lf", Res[i]);
		 	fprintf(results, "%c", '\n');
	}  
  fclose(results);
}

/* Function to write a scalar (double) to a file */
void DoubleScalarToFile(double Res, char fn[]){
	FILE *results;

	results = fopen(fn, "w");
 	if(results == NULL)
 	{
  		printf("SCALAR TO FILE:Error opening file containing vector of results for writing!\n");
  		exit(0);
 	}

 	fprintf(results, "%.12lf", Res);
 	fprintf(results, "%c", '\n');
		 	  
  fclose(results);
}

/* Function to write a scalar (double) to a file */
void DoubleScalarToOpenFile(double Res, FILE *results){
 	if(results == NULL)
 	{
  		printf("SCALAR TO FILE:Error opening file containing vector of results for writing!\n");
  		exit(0);
 	}

 	fprintf(results, "%.12lf", Res);
 	fprintf(results, "%c", '\n');
		 	  
}

/* Function to append a scalar (double) to a file */
void DoubleScalarToFileAPP(double Res, char fn[]){
	FILE *results;

	results = fopen(fn, "a+");
 	if(results == NULL)
 	{
  		printf("SCALAR TO FILE:Error opening file containing vector of results for writing!\n");
  		exit(0);
 	}

 	fprintf(results, "%.12lf", Res);
 	fprintf(results, "%c", '\n');
		 	  
  fclose(results);
}
