% linadvect - Programme to solve the linear advection equation. 
%
% There are two choices for the advection speed :
%
%       n = 1   gives   v = 1
%       n = 2   gives   v = (1 + x^2)/(1 + 2xt + 2x^2 + x^4)
%
% There are two choices for the initial condition :
%
%       n = 1   gives a square pulse   
%       n = 2   gives a Gaussian proifle
%
% There are three choices for the method :
%
%       n = 1   gives the upwind scheme
%       n = 2   gives the Lax scheme
%
clear; help linadvect;
global speed speed_dot n_speed init n_init nu x xhalf dx time dt n
%
%   Input parameters
%
speed = [@adspeed1; @adspeed2];
exact = [@exact1; @exact2];
n_speed = input('Enter the advection speed (1 or 2) -');
init = [@shape1; @shape2];
n_init = input('Enter the initial condition (1 or 2) -');
method = [@upwind; @lax];
n_method = input('Enter the method (1 or 2) -');
dx = input('Enter the grid spacing along the x-axis -');
cfl = input('Enter the Courant number -');
%
%   Set up grid and initial conditions
%
time = 0.;
tend = 1.;
xend = 3.*tend/2.;
n = ceil(xend/dx);
dt = cfl*dx;
nu = dt/dx;
x = ((1:n) - 1)*dx;
uold = feval(init(n_init),x);
uplot1 = uold;
uexact1 = uold;
time1 = 0.;
time4 = 1.;
ntime1 = floor(tend/(3*dt));
ntime2 = 2*ntime1;
i = 0;
%
%   Iterate the equations up to t=tend
%
while time <= tend    
    unew = feval(method(n_method),uold);
    time = time + dt;
    unew(1) = 0; unew(n) = 0;
    uold = unew;    
    i = i + 1;
    if i == ntime1
        uplot2 = unew;
        time2 = time;
        uexact2 = feval(exact(n_speed));
    end
    if i == ntime2
        uplot3 = unew;
        time3 = time;
        uexact3 = feval(exact(n_speed));
    end    
end
uplot4 = unew;
uexact4 = feval(exact(n_speed));
subplot(221)
    plot(x,uplot1,'o',x,uexact1)
    axis([0. 1.5 0. 1.1])
subplot(222)
    plot(x,uplot2,'o',x,uexact2)
    axis([0. 1.5 0. 1.1])
subplot(223)
    plot(x,uplot3,'o',x,uexact3)
    axis([0. 1.5 0. 1.1])
subplot(224)
    plot(x,uplot4,'o',x,uexact4)
    axis([0. 1.5 0. 1.1])
subplot(111)
return;