package com.owenlynch.eniac;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Form;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

import com.owenlynch.eniac.utils.Timer;
import com.owenlynch.graphics.ContourPlot;


import java.lang.Math;


public class EniacMIDlet extends MIDlet implements CommandListener {

	private Display display;
	
	private ContourPlot cPlot;

	private Command selectCmd;

	private Command backCmd;

	private Command exitCmd;

	private List mainScr;

	private Form calcScr;

	private String[] mainChoice = { "Calculate", "Exit" };
	
	private double[][] z0;
	
	private double[][] zFinal;

	public EniacMIDlet() {
		super();
		display = Display.getDisplay(this);
		selectCmd = new Command("Select", Command.OK, 1);
		exitCmd = new Command("Exit", Command.EXIT, 3);
		backCmd = new Command("Back", Command.BACK, 1);
	}

	private Displayable genMainScr() {
		if (mainScr == null) {
			mainScr = new List("ENIAC", List.IMPLICIT, mainChoice, null);
			mainScr.addCommand(selectCmd);
			mainScr.addCommand(exitCmd);
			mainScr.setCommandListener(this);
		}
		display.setCurrent(mainScr);
		return mainScr;
	}
	
	private Displayable genContourPlot(double[][] plot, double[][] plot2, long time)
	{
		cPlot = null;
		cPlot = new ContourPlot(plot, plot2, time);
		cPlot.addCommand(selectCmd);
		cPlot.addCommand(backCmd);
		display.setCurrent(cPlot);
		return cPlot;		
	}

	private void calculate() {
		if (calcScr == null) {
			calcScr = new Form("Calculate points");
			calcScr.addCommand(backCmd);
		}		
		//display.setCurrent(calcScr);
		EniacCalculator eCalc = new EniacCalculator();
		z0 = eCalc.getZ0();
		//genContourPlot(z0);	
		Timer timer = new Timer();
		timer.startTimer();
		eCalc.calculate();
		timer.stopTimer();
		zFinal = eCalc.getZFinal();		
		genContourPlot(z0, zFinal, timer.getTime());		
	}

	private void midletExit() {
		try {
			destroyApp(false);
		} catch (MIDletStateChangeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		notifyDestroyed();
	}

	protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
		// TODO Auto-generated method stub

	}

	protected void pauseApp() {
		// TODO Auto-generated method stub

	}

	protected void startApp() throws MIDletStateChangeException {		
		genMainScr();
		//calculate();		
		
	}

	public void commandAction(Command c, Displayable d) {
		if (d == mainScr) {
			if (c == exitCmd) {
				midletExit();
			} else if ((c == selectCmd) || (c == List.SELECT_COMMAND)) {
				switch (mainScr.getSelectedIndex()) {
				case 0:
					calculate();
					//genContourPlot(zFinal);					
					break;
				case 1:
					midletExit();
					break;
				}
			}
		}
		if (d == cPlot) {
			if (c == exitCmd) {
				midletExit();
			} else if ((c == selectCmd) || (c == List.SELECT_COMMAND)) {
				//genContourPlot(zFinal);				
			}
		}

	}

}
