package com.owenlynch.graphics;

import java.io.IOException;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ContourPlot extends Canvas{

	double[][] z0;
	double[][] zFinal;
	long timeTaken;
	int check = 0;
	int count = 0;

	private Image bgMap;
	private Image bgScaled;
	
	final int BACKGROUND_COL = 0xADEAEA;//0x000044; //navy //white
	final int FOREGROUND_COL = 0x000000;//0xFFFFFF;  //white //black
	final int HIGHLIGHT_COL = 0xA62A2A;// 0xFFFFBB;  // yellow //red
	final int BOX_COL = 0xFFFFFF;//0xAAAA44; //0xDDDDDD; /// grey
	final int BLUE_COL = 0x0000FF; /// BLUE

	int nrows, ncols;
	// cell Dimensiions
	int cell;
	// board dimensions
	int xboard, yboard;
	int x,y;
	int xtop,ytop;
	int width;
	int height;
	
	public ContourPlot()
	{
	}
	
	public ContourPlot(double[][] zin, double[][] zin2, long time)
	{
		try {
			bgMap = Image.createImage("/images/cplot.png");
		} catch (IOException e) {
			System.out.println("PROBLEM LOADING THE IMAGE");
			e.printStackTrace();
		}
		setFullScreenMode(true);
		// get dimesion information
		width = getWidth();
		height = getHeight();
		z0 = new double[zin.length][zin[0].length];
		for (int i = 0 ; i < zin.length ; i++){
			for (int j = 0 ; j < zin[0].length ; j++){
					z0[i][j] = zin[i][j];
			}
		}
		zFinal = new double[zin2.length][zin2[0].length];
		for (int i = 0 ; i < zin2.length ; i++){
			for (int j = 0 ; j < zin2[0].length ; j++){
					zFinal[i][j] = zin2[i][j];
			}
		}
		
		timeTaken = time;
	}

	protected void paint(Graphics g) {

		nrows = z0.length;
		ncols = z0[0].length;
		// calculate the size of a cell

		cell = width / (nrows-1);

		// board dimensions
		xboard = cell * (nrows-1);
		yboard = cell * (ncols-1);
		xtop = (width-xboard)/2;
		ytop = (height-yboard)/2;
		x = xtop;
		y = ytop;

		// clear canvas
		g.setColor(BACKGROUND_COL);
		g.fillRect(0,0,width,height);
		bgScaled = scale(bgMap,xboard,yboard);
		//g.drawImage( bgMap, (width - bgMap.getWidth())/2, (height -bgMap.getHeight())/2 , Graphics.TOP | Graphics.LEFT );
		g.drawImage( bgScaled, x, y, Graphics.TOP | Graphics.LEFT );
		int x1,x2,y1,y2;
		g.setColor(BOX_COL);
		
		
		/*
		remove later
		// Draw the Background Grid,
		// first  the rows
		for (int i = 0 ; i < nrows ; i++){

			x1 = xtop+i*cell;
			x2 = xtop+i*cell;
			y1 = ytop;
			y2 = ytop+yboard;
			g.drawLine(x1,y1,x2,y2);

		}
		// then the columns
		for (int i = 0 ; i < ncols ; i++){
			g.setColor(BOX_COL);
			x1 = xtop;
			x2 = xtop+xboard;//-cell;
			y1 = ytop+i*cell;
			y2 = y1;
			g.drawLine(x1,y1,x2,y2);
		}

		*/
		
		// --------------------------
		// Define a test array
		double[][] zz = new double[nrows][ncols];
		//
		if (check == 0)
		{
			// Flip array up / down
			g.setColor(FOREGROUND_COL);
		 	g.drawString("Analysis",6 , 6, Graphics.TOP | Graphics.LEFT);
			for (int i = 0 ; i < nrows ; i++){
				for (int j = 0 ; j < ncols ; j++){
						zz[i][j] = z0[i][ncols-1-j];
				}
			}
		}
		if (check == 1)
		{
			// Flip array up / down
			g.setColor(FOREGROUND_COL);
			g.drawString("Forecast",6 , 6, Graphics.TOP | Graphics.LEFT);
			for (int i = 0 ; i < nrows ; i++){
				for (int j = 0 ; j < ncols ; j++){
						zz[i][j] = zFinal[i][ncols-1-j];
				}
			}
		}

		if (check == 2)
		{
			g.setColor(FOREGROUND_COL);
			g.drawString("Time Taken: "+timeTaken+" ms.",6 , 6, Graphics.TOP | Graphics.LEFT);
			// Flip array up / down
			for (int i = 0 ; i < nrows ; i++){
				for (int j = 0 ; j < ncols ; j++){
						zz[i][j] = zFinal[i][ncols-1-j];
				}
			}
		}

		// ----------------------
        // Define plotting contours
		g.setColor(HIGHLIGHT_COL);
		double zz1;
		double zz2;
		double [] zcontours = new double[36];
		for (int nc = 0 ; nc < zcontours.length ; nc++)
		{
			zcontours[nc] = 4500+(nc*60);
		}
		double zcon=0;
		int kcon=0;
		double wt=0;
		double [] xp=new double[4];
		double [] yp=new double[4];

		for (int i = 0 ; i < nrows-1 ; i++){
		for (int j = 0 ; j < ncols-1 ; j++){

			x1 = xtop+i*cell;
			x2 = x1+cell;
			y1 = ytop+j*cell;
			y2 = y1+cell;
			// g.drawLine(x1,y2,x2,y1);

			// Loop for each contour
			for (int ncon=0; ncon<zcontours.length; ncon++){
				zcon = zcontours[ncon];

			// Reset contour counter.
			kcon = 0;

			// Test top edge for contour value
			zz1 = zz[i][j];
			zz2 = zz[i+1][j];
			if ( zcon >= Math.min(zz1,zz2) && zcon <= Math.max(zz1,zz2))
			{
				wt = (zcon-zz1)/(zz2-zz1);
				xp[kcon] = x1+wt*cell;
				yp[kcon] = y1;
				kcon++;
			}
//			Test bottom edge for contour value
			zz1 = zz[i][j+1];
			zz2 = zz[i+1][j+1];
			if ( zcon >= Math.min(zz1,zz2) && zcon <= Math.max(zz1,zz2))
			{
				wt = (zcon-zz1)/(zz2-zz1);
				xp[kcon] = x1+wt*cell;
				yp[kcon] = y2;
				kcon++;
			}
//			Test left edge for contour value
			zz1 = zz[i][j];
			zz2 = zz[i][j+1];
			if ( zcon >= Math.min(zz1,zz2) && zcon <= Math.max(zz1,zz2))
			{
				wt = (zcon-zz1)/(zz2-zz1);
				xp[kcon] = x1;
				yp[kcon] = y1+wt*cell;
				kcon++;
			}
//			Test right edge for contour value
			zz1 = zz[i+1][j];
			zz2 = zz[i+1][j+1];
			if ( zcon >= Math.min(zz1,zz2) && zcon <= Math.max(zz1,zz2))
			{
				wt = (zcon-zz1)/(zz2-zz1);
				xp[kcon] = x2;
				yp[kcon] = y1+wt*cell;
				kcon++;
			}

			if ( kcon>0 )
			{
				g.drawLine((int)xp[0],(int)yp[0],(int)xp[1],(int)yp[1]);
			}
			if ( kcon>2 )
			{
				g.drawLine((int)xp[2],(int)yp[2],(int)xp[3],(int)yp[3]);
			}

			} // End of contour loop
		}
		}

	}

	public void keyPressed(int keycode){
		int code = getGameAction(keycode);

		switch(code){

		case Canvas.FIRE:
			count++;
			check = count %3;
			repaint();
			repaint();
			break;
		}
	}
	public static Image scale(Image src, int width, int height)
	{
		//long start = System.currentTimeMillis();
		int scanline = src.getWidth();
		int srcw = src.getWidth();
		int srch = src.getHeight();
		int buf[] = new int[srcw * srch];
		src.getRGB(buf, 0, scanline, 0, 0, srcw, srch);
		int buf2[] = new int[width*height];
		for (int y=0;y<height;y++)
			{
			int c1 = y*width;
			int c2 = (y*srch/height)*scanline;
			for (int x=0;x<width;x++)
				{
				buf2[c1 + x] = buf[c2 + x*srcw/width];
				}
			}		
		Image img = Image.createRGBImage(buf2, width, height, true);
		//long end = System.currentTimeMillis();
		//System.out.println("Scaled "+src.getWidth()+"x"+src.getHeight()+" in "+((end-start)/1000)+" seconds");
		return img;
	}
}
