/*
 * Decompiled with CFR 0.152.
 */
package com.owenlynch.eniac;

import com.owenlynch.eniac.EniacCalculator;
import com.owenlynch.eniac.utils.Timer;
import com.owenlynch.graphics.ContourPlot;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class EniacMIDlet
extends MIDlet
implements CommandListener {
    private Display display;
    private ContourPlot cPlot;
    private Command selectCmd;
    private Command backCmd;
    private Command exitCmd;
    private List mainScr;
    private Form calcScr;
    private String[] mainChoice = new String[]{"Calculate", "Exit"};
    private double[][] z0;
    private double[][] zFinal;

    public EniacMIDlet() {
        this.display = Display.getDisplay((MIDlet)this);
        this.selectCmd = new Command("Select", 4, 1);
        this.exitCmd = new Command("Exit", 7, 3);
        this.backCmd = new Command("Back", 2, 1);
    }

    private Displayable genMainScr() {
        if (this.mainScr == null) {
            this.mainScr = new List("ENIAC", 3, this.mainChoice, null);
            this.mainScr.addCommand(this.selectCmd);
            this.mainScr.addCommand(this.exitCmd);
            this.mainScr.setCommandListener((CommandListener)this);
        }
        this.display.setCurrent((Displayable)this.mainScr);
        return this.mainScr;
    }

    private Displayable genContourPlot(double[][] dArray, double[][] dArray2, long l) {
        this.cPlot = null;
        this.cPlot = new ContourPlot(dArray, dArray2, l);
        this.cPlot.addCommand(this.selectCmd);
        this.cPlot.addCommand(this.backCmd);
        this.display.setCurrent((Displayable)this.cPlot);
        return this.cPlot;
    }

    private void calculate() {
        if (this.calcScr == null) {
            this.calcScr = new Form("Calculate points");
            this.calcScr.addCommand(this.backCmd);
        }
        EniacCalculator eniacCalculator = new EniacCalculator();
        this.z0 = eniacCalculator.getZ0();
        Timer timer = new Timer();
        timer.startTimer();
        eniacCalculator.calculate();
        timer.stopTimer();
        this.zFinal = eniacCalculator.getZFinal();
        this.genContourPlot(this.z0, this.zFinal, timer.getTime());
    }

    private void midletExit() {
        try {
            this.destroyApp(false);
        }
        catch (MIDletStateChangeException mIDletStateChangeException) {
            mIDletStateChangeException.printStackTrace();
        }
        this.notifyDestroyed();
    }

    protected void destroyApp(boolean bl) throws MIDletStateChangeException {
    }

    protected void pauseApp() {
    }

    protected void startApp() throws MIDletStateChangeException {
        this.genMainScr();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.mainScr) {
            if (command == this.exitCmd) {
                this.midletExit();
            } else if (command == this.selectCmd || command == List.SELECT_COMMAND) {
                switch (this.mainScr.getSelectedIndex()) {
                    case 0: {
                        this.calculate();
                        break;
                    }
                    case 1: {
                        this.midletExit();
                    }
                }
            }
        }
        if (displayable == this.cPlot) {
            if (command == this.exitCmd) {
                this.midletExit();
            } else if (command == this.selectCmd || command == List.SELECT_COMMAND) {
                // empty if block
            }
        }
    }
}

