/*
 * Decompiled with CFR 0.152.
 */
package com.owenlynch.graphics;

import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ContourPlot
extends Canvas {
    double[][] z0;
    double[][] zFinal;
    long timeTaken;
    int check = 0;
    int count = 0;
    private Image bgMap;
    private Image bgScaled;
    final int BACKGROUND_COL;
    final int FOREGROUND_COL;
    final int HIGHLIGHT_COL;
    final int BOX_COL;
    final int BLUE_COL;
    int nrows;
    int ncols;
    int cell;
    int xboard;
    int yboard;
    int x;
    int y;
    int xtop;
    int ytop;
    int width;
    int height;

    public ContourPlot() {
        this.BACKGROUND_COL = 0xADEAEA;
        this.FOREGROUND_COL = 0;
        this.HIGHLIGHT_COL = 0xA62A2A;
        this.BOX_COL = 0xFFFFFF;
        this.BLUE_COL = 255;
    }

    public ContourPlot(double[][] dArray, double[][] dArray2, long l) {
        int n;
        int n2;
        this.BACKGROUND_COL = 0xADEAEA;
        this.FOREGROUND_COL = 0;
        this.HIGHLIGHT_COL = 0xA62A2A;
        this.BOX_COL = 0xFFFFFF;
        this.BLUE_COL = 255;
        try {
            this.bgMap = Image.createImage((String)"/images/cplot.png");
        }
        catch (IOException iOException) {
            System.out.println("PROBLEM LOADING THE IMAGE");
            iOException.printStackTrace();
        }
        this.setFullScreenMode(true);
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.z0 = new double[dArray.length][dArray[0].length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray[0].length; ++n) {
                this.z0[n2][n] = dArray[n2][n];
            }
        }
        this.zFinal = new double[dArray2.length][dArray2[0].length];
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            for (n = 0; n < dArray2[0].length; ++n) {
                this.zFinal[n2][n] = dArray2[n2][n];
            }
        }
        this.timeTaken = l;
    }

    protected void paint(Graphics graphics) {
        int n;
        int n2;
        this.nrows = this.z0.length;
        this.ncols = this.z0[0].length;
        this.cell = this.width / (this.nrows - 1);
        this.xboard = this.cell * (this.nrows - 1);
        this.yboard = this.cell * (this.ncols - 1);
        this.xtop = (this.width - this.xboard) / 2;
        this.ytop = (this.height - this.yboard) / 2;
        this.x = this.xtop;
        this.y = this.ytop;
        graphics.setColor(0xADEAEA);
        graphics.fillRect(0, 0, this.width, this.height);
        this.bgScaled = ContourPlot.scale(this.bgMap, this.xboard, this.yboard);
        graphics.drawImage(this.bgScaled, this.x, this.y, 20);
        graphics.setColor(0xFFFFFF);
        double[][] dArray = new double[this.nrows][this.ncols];
        if (this.check == 0) {
            graphics.setColor(0);
            graphics.drawString("Analysis", 6, 6, 20);
            for (n2 = 0; n2 < this.nrows; ++n2) {
                for (n = 0; n < this.ncols; ++n) {
                    dArray[n2][n] = this.z0[n2][this.ncols - 1 - n];
                }
            }
        }
        if (this.check == 1) {
            graphics.setColor(0);
            graphics.drawString("Forecast", 6, 6, 20);
            for (n2 = 0; n2 < this.nrows; ++n2) {
                for (n = 0; n < this.ncols; ++n) {
                    dArray[n2][n] = this.zFinal[n2][this.ncols - 1 - n];
                }
            }
        }
        if (this.check == 2) {
            graphics.setColor(0);
            graphics.drawString("Time Taken: " + this.timeTaken + " ms.", 6, 6, 20);
            for (n2 = 0; n2 < this.nrows; ++n2) {
                for (n = 0; n < this.ncols; ++n) {
                    dArray[n2][n] = this.zFinal[n2][this.ncols - 1 - n];
                }
            }
        }
        graphics.setColor(0xA62A2A);
        double[] dArray2 = new double[36];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = 4500 + i * 60;
        }
        double d = 0.0;
        int n3 = 0;
        double d2 = 0.0;
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[4];
        for (int i = 0; i < this.nrows - 1; ++i) {
            for (int j = 0; j < this.ncols - 1; ++j) {
                int n4 = this.xtop + i * this.cell;
                int n5 = n4 + this.cell;
                int n6 = this.ytop + j * this.cell;
                int n7 = n6 + this.cell;
                for (int k = 0; k < dArray2.length; ++k) {
                    d = dArray2[k];
                    n3 = 0;
                    double d3 = dArray[i][j];
                    double d4 = dArray[i + 1][j];
                    if (d >= Math.min(d3, d4) && d <= Math.max(d3, d4)) {
                        d2 = (d - d3) / (d4 - d3);
                        dArray3[n3] = (double)n4 + d2 * (double)this.cell;
                        dArray4[n3] = n6;
                        ++n3;
                    }
                    if (d >= Math.min(d3 = dArray[i][j + 1], d4 = dArray[i + 1][j + 1]) && d <= Math.max(d3, d4)) {
                        d2 = (d - d3) / (d4 - d3);
                        dArray3[n3] = (double)n4 + d2 * (double)this.cell;
                        dArray4[n3] = n7;
                        ++n3;
                    }
                    if (d >= Math.min(d3 = dArray[i][j], d4 = dArray[i][j + 1]) && d <= Math.max(d3, d4)) {
                        d2 = (d - d3) / (d4 - d3);
                        dArray3[n3] = n4;
                        dArray4[n3] = (double)n6 + d2 * (double)this.cell;
                        ++n3;
                    }
                    if (d >= Math.min(d3 = dArray[i + 1][j], d4 = dArray[i + 1][j + 1]) && d <= Math.max(d3, d4)) {
                        d2 = (d - d3) / (d4 - d3);
                        dArray3[n3] = n5;
                        dArray4[n3] = (double)n6 + d2 * (double)this.cell;
                        ++n3;
                    }
                    if (n3 > 0) {
                        graphics.drawLine((int)dArray3[0], (int)dArray4[0], (int)dArray3[1], (int)dArray4[1]);
                    }
                    if (n3 <= 2) continue;
                    graphics.drawLine((int)dArray3[2], (int)dArray4[2], (int)dArray3[3], (int)dArray4[3]);
                }
            }
        }
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 8: {
                ++this.count;
                this.check = this.count % 3;
                this.repaint();
                this.repaint();
            }
        }
    }

    public static Image scale(Image image, int n, int n2) {
        int n3 = image.getWidth();
        int n4 = image.getWidth();
        int n5 = image.getHeight();
        int[] nArray = new int[n4 * n5];
        image.getRGB(nArray, 0, n3, 0, 0, n4, n5);
        int[] nArray2 = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            int n6 = i * n;
            int n7 = i * n5 / n2 * n3;
            for (int j = 0; j < n; ++j) {
                nArray2[n6 + j] = nArray[n7 + j * n4 / n];
            }
        }
        Image image2 = Image.createRGBImage((int[])nArray2, (int)n, (int)n2, (boolean)true);
        return image2;
    }
}

