/*
 * Decompiled with CFR 0.152.
 */
package com.owenlynch.eniac.maths;

public class Maths {
    private static final float LOWER_BOUND = 0.9999999f;
    private static final float UPPER_BOUND = 1.0f;
    static final double ln2 = 0.69314718055995;

    private static double ArcTan(double d) {
        double d2 = d * d;
        return (0.7162721157073975 + 0.2996857762336731 * d2) * d / (0.7163164615631104 + (0.5377299189567566 + 0.039516203105449677 * d2) * d2);
    }

    public static double atan(double d) {
        return Maths.atan2(d, 1.0);
    }

    public static double log(double d) {
        double d2;
        double d3;
        if (d < 1.0) {
            return -Maths.log(1.0 / d);
        }
        double d4 = 0.0;
        for (d3 = 1.0; d3 <= d; d3 *= 2.0) {
            d4 += 1.0;
        }
        d4 -= 1.0;
        double d5 = d / (d3 / 2.0);
        double d6 = d2 = (1.0 - d5) / (1.0 + d5);
        double d7 = d2;
        double d8 = d2 * d2;
        int n = 1;
        double d9;
        double d10;
        while (!((d10 = d7 / (d9 = d7 + (d6 *= d8) / (double)(2 * n + 1))) >= 0.9999998807907104) || !(d10 <= 1.0)) {
            d7 = d9;
            ++n;
        }
        return d4 * 0.69314718055995 - 2.0 * d7;
    }

    public static double atan2(double d, double d2) {
        float f = (float)Math.abs(d2);
        float f2 = (float)Math.abs(d);
        if ((double)f < 1.0E-7 && (double)f2 < 1.0E-7) {
            return 0.0;
        }
        if (f > f2) {
            if (d2 < 0.0) {
                if (d >= 0.0) {
                    return Maths.ArcTan(d / d2) + Math.PI;
                }
                return Maths.ArcTan(d / d2) - Math.PI;
            }
            return Maths.ArcTan(d / d2);
        }
        if (d < 0.0) {
            return Maths.ArcTan(-d2 / d) - 1.5707963267948966;
        }
        return Maths.ArcTan(-d2 / d) + 1.5707963267948966;
    }

    public static double exp(double d) {
        double d2;
        boolean bl;
        boolean bl2 = bl = d < 0.0;
        if (d < 0.0) {
            d = -d;
        }
        int n = 1;
        double d3 = d;
        double d4 = 0.0;
        double d5 = 0.0;
        while ((d2 = (d4 += (d3 *= d / (double)(++n))) / (d5 = d4)) < 0.9999998807907104 || d2 > 1.0) {
        }
        return bl ? 1.0 / d4 : (d4 += 1.0);
    }

    public static double pow(double d, double d2) {
        return Maths.exp(d2 * Maths.log(d));
    }
}

