/*
 * Decompiled with CFR 0.152.
 */
package com.owenlynch.eniac.maths;

public class MathFunc {
    private static final float LOWER_BOUND = 0.9999999f;
    private static final float UPPER_BOUND = 1.0f;
    static final double ln2 = 0.69314718055995;

    private static double ArcTan(double d) {
        double d2 = d * d;
        return (0.7162721157073975 + 0.2996857762336731 * d2) * d / (0.7163164615631104 + (0.5377299189567566 + 0.039516203105449677 * d2) * d2);
    }

    public static double atan(double d) {
        return MathFunc.atan2(d, 1.0);
    }

    public static double atan2(double d, double d2) {
        float f = (float)Math.abs(d2);
        float f2 = (float)Math.abs(d);
        if ((double)f < 1.0E-7 && (double)f2 < 1.0E-7) {
            return 0.0;
        }
        if (f > f2) {
            if (d2 < 0.0) {
                if (d >= 0.0) {
                    return MathFunc.ArcTan(d / d2) + Math.PI;
                }
                return MathFunc.ArcTan(d / d2) - Math.PI;
            }
            return MathFunc.ArcTan(d / d2);
        }
        if (d < 0.0) {
            return MathFunc.ArcTan(-d2 / d) - 1.5707963267948966;
        }
        return MathFunc.ArcTan(-d2 / d) + 1.5707963267948966;
    }

    public static double log(double d) {
        double d2;
        double d3;
        if (d < 1.0) {
            return -MathFunc.log(1.0 / d);
        }
        double d4 = 0.0;
        for (d3 = 1.0; d3 <= d; d3 *= 2.0) {
            d4 += 1.0;
        }
        d4 -= 1.0;
        double d5 = d / (d3 / 2.0);
        double d6 = d2 = (1.0 - d5) / (1.0 + d5);
        double d7 = d2;
        double d8 = d2 * d2;
        int n = 1;
        double d9;
        double d10;
        while (!((d10 = d7 / (d9 = d7 + (d6 *= d8) / (double)(2 * n + 1))) >= 0.9999998807907104) || !(d10 <= 1.0)) {
            d7 = d9;
            ++n;
        }
        return d4 * 0.69314718055995 - 2.0 * d7;
    }

    public static double exp(double d) {
        double d2;
        boolean bl;
        boolean bl2 = bl = d < 0.0;
        if (d < 0.0) {
            d = -d;
        }
        int n = 1;
        double d3 = d;
        double d4 = 0.0;
        double d5 = 0.0;
        while ((d2 = (d4 += (d3 *= d / (double)(++n))) / (d5 = d4)) < 0.9999998807907104 || d2 > 1.0) {
        }
        return bl ? 1.0 / d4 : (d4 += 1.0);
    }

    public static double pow(double d, double d2) {
        return MathFunc.exp(d2 * MathFunc.log(d));
    }

    public static double[][] ddx(double[][] dArray, double d) {
        double[][] dArray2 = new double[dArray.length][dArray[0].length];
        for (int i = 1; i < dArray.length - 1; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                dArray2[i][j] = (dArray[i + 1][j] - dArray[i - 1][j]) / (2.0 * d);
            }
        }
        return dArray2;
    }

    public static double[][] ddy(double[][] dArray, double d) {
        double[][] dArray2 = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 1; j < dArray[i].length - 1; ++j) {
                dArray2[i][j] = (dArray[i][j + 1] - dArray[i][j - 1]) / (2.0 * d);
            }
        }
        return dArray2;
    }

    public static double[][] ddx2(double[][] dArray, double d) {
        double[][] dArray2 = new double[dArray.length][dArray[0].length];
        for (int i = 1; i < dArray.length - 1; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                dArray2[i][j] = (dArray[i + 1][j] + dArray[i - 1][j] - 2.0 * dArray[i][j]) / (d * d);
            }
        }
        return dArray2;
    }

    public static double[][] ddy2(double[][] dArray, double d) {
        double[][] dArray2 = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 1; j < dArray[i].length - 1; ++j) {
                dArray2[i][j] = (dArray[i][j + 1] + dArray[i][j - 1] - 2.0 * dArray[i][j]) / (d * d);
            }
        }
        return dArray2;
    }

    public static double[][] boundaryFill(double[][] dArray) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[][] dArray2 = new double[n2][n3];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        for (n = 1; n < n2 - 1; ++n) {
            dArray2[n][0] = 2.0 * dArray2[n][1] - dArray2[n][2];
            dArray2[n][n3 - 1] = 2.0 * dArray2[n][n3 - 2] - dArray2[n][n3 - 3];
        }
        for (n = 0; n < n3; ++n) {
            dArray2[0][n] = 2.0 * dArray2[1][n] - dArray2[2][n];
            dArray2[n2 - 1][n] = 2.0 * dArray2[n2 - 2][n] - dArray2[n2 - 3][n];
        }
        return dArray2;
    }

    public static double[][] dotStar(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray3 = new double[n][n2];
        for (int i = 0; i < dArray3.length; ++i) {
            for (int j = 0; j < dArray3[i].length; ++j) {
                dArray3[i][j] = dArray[i][j] * dArray2[i][j];
            }
        }
        return dArray3;
    }

    public static double[][] dotDivide(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray3 = new double[n][n2];
        for (int i = 0; i < dArray3.length; ++i) {
            for (int j = 0; j < dArray3[i].length; ++j) {
                dArray3[i][j] = dArray[i][j] / dArray2[i][j];
            }
        }
        return dArray3;
    }

    public static double[][] matrixMult(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray2[0].length;
        int n4 = dArray2.length;
        if (n2 != n4) {
            System.out.println("matrixMult - b != b1");
        }
        double[][] dArray3 = new double[n][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                dArray3[i][j] = 0.0;
                for (int k = 0; k < n2; ++k) {
                    dArray3[i][j] = dArray3[i][j] + dArray[i][k] * dArray2[k][j];
                }
            }
        }
        return dArray3;
    }

    public static double[][] matrixAdd(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray3 = new double[n][n2];
        for (int i = 0; i < dArray3.length; ++i) {
            for (int j = 0; j < dArray3[i].length; ++j) {
                dArray3[i][j] = dArray[i][j] + dArray2[i][j];
            }
        }
        return dArray3;
    }

    public static double[][] matrixSub(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray3 = new double[n][n2];
        for (int i = 0; i < dArray3.length; ++i) {
            for (int j = 0; j < dArray3[i].length; ++j) {
                dArray3[i][j] = dArray[i][j] - dArray2[i][j];
            }
        }
        return dArray3;
    }

    public static double matrixMax(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double d = -1.0E51;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (!(dArray[i][j] > d)) continue;
                d = dArray[i][j];
            }
        }
        return d;
    }

    public static double matrixMin(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double d = 1.0E51;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (!(dArray[i][j] < d)) continue;
                d = dArray[i][j];
            }
        }
        return d;
    }

    public static double[][] matrixScale(double[][] dArray, double d) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[i][j] = dArray[i][j] * d;
            }
        }
        return dArray2;
    }

    public static double matrixElementsSum(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                d += dArray[i][j];
            }
        }
        return d;
    }

    public static double[][] matrixReduce(double[][] dArray) {
        double[][] dArray2 = new double[dArray.length - 2][dArray[0].length - 2];
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[i].length; ++j) {
                dArray2[i][j] = dArray[i + 1][j + 1];
            }
        }
        return dArray2;
    }

    public static double[][] matrixExtend(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n + 2][n2 + 2];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                dArray2[i + 1][j + 1] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static double[][] matrixInterior(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[i + 1][j + 1] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static double sign(double d) {
        if (d > 0.0) {
            return 1.0;
        }
        if (d == 0.0) {
            return 0.0;
        }
        return -1.0;
    }
}

