#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include<math.h>
#include<time.h>

void freeIntMat(int **Mat, int nrows){
	int i;
	for(i=0; i<nrows; i++)
		free(Mat[i]);
	free(Mat);
}

void freeDoubleMat(double **Mat, int nrows){
	int i;
	for(i=0; i<nrows; i++)
		free(Mat[i]);
	free(Mat);
}

void freeCharMat(char **Mat, int nrows){
	int i;
	for(i=0; i<nrows; i++)
		free(Mat[i]);
	free(Mat);
}

void freeDoubleArray3d(double ***Mat, int nsheets, int nrows){
	int i;
	for(i=0; i<nsheets; i++)
			freeDoubleMat(Mat[i], nrows);
	free(Mat);
}

int *OnedIntMemAlloc(int dimension1)
{
 int *arr;

 arr = (int *)calloc(dimension1, sizeof(int));
 if(arr == NULL)
 {
  printf("Error allocating memory!\n");
  exit(0);
 }
/* printf("Allocated one d int array.\n"); */
 return(arr);
 free(arr);
}

int **TwodIntMemAlloc(int nrows, int ncols)
{
 int i;
 int **arr;

 arr = (int **) calloc (nrows, sizeof(int *));
 for(i=0; i<nrows; i++)
 {
  arr[i] = (int *) calloc(ncols, sizeof(int));
  if(arr[i] == NULL)
  {
   printf("Error allocating memory!\n");
   exit(0);
  }
 }
  
/* printf("Allocated two d int array.\n");*/ 
 return(arr);
 freeIntMat(arr, nrows);
}

double *OnedDoubleMemAlloc(int dimension1)
{
 double *arr;

 arr = (double *) calloc(dimension1, sizeof(double));
 if(arr == NULL)
 {
  printf("Error allocating memory!\n");
  exit(0);
 }
/* printf("Allocated one d double array.\n");*/
 return(arr);
 free(arr);
}


double **TwodDoubleMemAlloc(int nrows, int ncols)
{
 int i;
 double **arr;

 arr = (double **) calloc(nrows, sizeof(double *));

 for(i=0; i<nrows; i++)
 {
  arr[i] = (double *) calloc(ncols, sizeof(double));
  if(arr[i] == NULL)
  {
   printf("Error allocating memory!\n");
   exit(0);
  }
 }
/* printf("Allocated two d double array.\n");*/ 
 return(arr);
 freeDoubleMat(arr, nrows);
}


char *OnedCharMemAlloc(int dimension1)
{
 char *arr;

 arr = (char *)malloc(dimension1*sizeof(char));
 if(arr == NULL)
 {
  printf("Error allocating memory!\n");
  exit(0);
 }

/* printf("Allocated one d char array.\n");*/ 
 return(arr);
 free(arr);
}

char **TwodCharMemAlloc(int nrows, int ncols)
{
 int i;
 char **arr;

 arr = (char **) malloc(nrows*sizeof(char *));

 for(i=0; i<nrows; i++)
 {
  arr[i] = (char *) malloc(ncols*sizeof(char));
  if(arr[i] == NULL)
  {
   printf("Error allocating memory!\n");
   exit(0);
  }
 }
/* printf("Allocated two d char array.\n");*/ 
 return(arr);
 freeCharMat(arr, nrows);
}

double ***ThreedDoubleMemAlloc(int nsheets, int nrows, int ncols)
{
 	int i, j;
 	double ***arr;

 	arr = (double ***) calloc(nsheets, sizeof(double **));

 	for(i=0; i<nsheets; i++)
 	{
		arr[i] = (double **) calloc(nrows, sizeof(double *));
		for(j=0; j<nrows; j++){
  			arr[i][j] = (double *) calloc(ncols, sizeof(double));

			if(arr[i][j] == NULL)
			{
				printf("Error allocating memory!\n");
				exit(0);
  			}
		}
	}
/* printf("Allocated two d double array.\n");*/ 
 return(arr);
 freeDoubleArray3d(arr, nsheets, nrows);
}


