#include<stdio.h>
#include<stdlib.h>
#include<math.h>

#include "Mem.h"
#include "MiscCFuncs.h"

double *DoubleVecAdd(double *v1, int lv1, double *v2, int lv2){
	int i;
	double *res = OnedDoubleMemAlloc(lv1);

	if(lv1!=lv2){
		printf("Vector dimensions do not match! \n");
	}

	for(i=0; i<lv1; i++)
		res[i] = v1[i] + v2[i];

return(res);
free(res);
}

double *DoubleVecSub(double *v1, int lv1, double *v2, int lv2){
	int i;
	double *res = OnedDoubleMemAlloc(lv1);

	if(lv1!=lv2){
		printf("Vector dimensions do not match!");
	}

	for(i=0; i<lv1; i++)
		res[i] = v1[i] - v2[i];

return(res);
free(res);
}

/* Function to multiply each entry of v1 by the corresponding entry of v2 */
double *DoubleVecMul(double *v1, int lv1, double *v2, int lv2){
	int i;
	double *res = OnedDoubleMemAlloc(lv1);

	if(lv1!=lv2){
		printf("Vector dimensions do not match!");
	}

	for(i=0; i<lv1; i++)
		res[i] = v1[i]*v2[i];

return(res);
free(res);
}

/* Function to divide each entry of v1 by the corresponding entry of v2 */
double *DoubleVecDiv(double *v1, int lv1, double *v2, int lv2){
	int i;
	double *res = OnedDoubleMemAlloc(lv1);

	if(lv1!=lv2){
		printf("Vector dimensions do not match!");
	}

	for(i=0; i<lv1; i++)
		res[i] = v1[i]/v2[i];

return(res);
free(res);
}

double DotProd(double *v1, int lv1, double *v2, int lv2){
	int i;
	double res = 0.0;

	if(lv1!=lv2){
		printf("DotProd:Vector dimensions do not match!");
	}
	
	for(i=0; i<lv1; i++)
		res += v1[i]*v2[i];

	return(res);
}

/* Add two double matrices */
double **DoubleMatAdd(double **A, int rA, int cA, double **B, int rB, int cB){
	int i, j;
	double **Res = TwodDoubleMemAlloc(rA, cA);

	for (i=0; i<rA; i++){
		for (j=0; j<cB; j++){
			Res[i][j] = A[i][j] + B[i][j];
		} /*j*/
	}	/*i*/
	return(Res);
	freeDoubleMat(Res, rA);
}

/* Subtract two double matrices */
double **DoubleMatSub(double **A, int rA, int cA, double **B, int rB, int cB){
	int i, j;
	double **Res = TwodDoubleMemAlloc(rA, cA);

	for (i=0; i<rA; i++){
		for (j=0; j<cB; j++){
			Res[i][j] = A[i][j] - B[i][j];
		} /*j*/
	}	/*i*/
	return(Res);
	freeDoubleMat(Res, rA);
}

/* Function to multiply a matrix by a vector */
double *DoubleMatVecMul(double **A, int rA, int cA, double *b, int lb, int pre){
	int i, k;
	double *Res = OnedDoubleMemAlloc(rA);
	if(pre != 0 && pre!= 1)
		printf("Invalid pre value (must be 0 or 1)!");

	if(pre == 1){
		if(rA!=lb){
			printf("Incompatible dimensions!");
		}

		for (i=0; i<cA; i++){
				Res[i] = 0;
				for (k=0; k<rA; k++)
					Res[i] += A[k][i]*b[k];
		}	/*i*/
	}else{
		if(cA!=lb){
			printf("Incompatible dimensions!");
		}

		for (i=0; i<rA; i++){
				Res[i] = 0;
				for (k=0; k<lb; k++)
					Res[i] += A[i][k]*b[k];
		}	/*i*/
	}
	return(Res);
	free(Res);
}

/* Function to multiply a vector by a scalar */
double *DoubleScalarVecMul(double *a, int la, double k){
	int i;
	double *Res = OnedDoubleMemAlloc(la);

	for (i=0; i<la; i++){
			Res[i] = k*a[i];
	}	/*i*/
	return(Res);
	free(Res);
}

/* Function to add a scalar to each entry of a vector */
double *DoubleScalarVecAdd(double *a, int la, double k){
	int i;
	double *Res = OnedDoubleMemAlloc(la);

	for (i=0; i<la; i++){
			Res[i] = a[i]+k;
	}	/*i*/
	return(Res);
	free(Res);
}

/* Function to subtract a scalar from each entry in a vector */
double *DoubleScalarVecSub(double *a, int la, double k){
	int i;
	double *Res = OnedDoubleMemAlloc(la);

	for (i=0; i<la; i++){
			Res[i] = a[i]-k;
	}	/*i*/
	return(Res);
	free(Res);
}

/* Function to add a scalar to a matrix */
double **DoubleScalarMatAdd(double **A, int rA, int cA, double k){
	int i, j;
	double **Res = TwodDoubleMemAlloc(rA, cA);

	for (i=0; i<rA; i++){
		for (j=0; j<cA; j++)
			Res[i][j] = k+A[i][j];
	}	/*i*/
	return(Res);
	freeDoubleMat(Res, rA);
}

/* Function to multiply a matrix by a scalar */
double **DoubleScalarMatMul(double **A, int rA, int cA, double k){
	int i, j;
	double **Res = TwodDoubleMemAlloc(rA, cA);

	for (i=0; i<rA; i++){
		for (j=0; j<cA; j++)
			Res[i][j] = k*A[i][j];
	}	/*i*/
	return(Res);
	freeDoubleMat(Res, rA);
}

double **DoubleMatMul(double **A, int rA, int cA, double **B, int rB, int cB){
	int i, j, k;
	double **Res = TwodDoubleMemAlloc(rA, cB);

	for (i=0; i<rA; i++){
		for (j=0; j<cB; j++){
			Res[i][j] = 0;

			for (k=0; k<rB; k++)
				Res[i][j] = Res[i][j] + A[i][k]*B[k][j];

		} /*j*/
	}	/*i*/
	return(Res);
	freeDoubleMat(Res, rA);
}
 
/* Calculate the transpose of a matrix */
double **MatTrans(double **A, int rA, int cA){
	int i, j;
	double **Res = TwodDoubleMemAlloc(cA, rA);

	for(i=0; i<rA; i++){
		for(j=0; j<cA; j++){
			Res[j][i] = A[i][j];
		}
	}
	return(Res);
	freeDoubleMat(Res, cA);
}

void transpose(int no_rows, int no_cols, double **regular, double **transposed)
{
 int i, j;
 double **interim;

 interim = TwodDoubleMemAlloc(no_rows, no_cols);

 for(i=0; i<no_rows; i++)
 {
   for(j=0; j<no_cols; j++)
   {
    interim[i][j] = (double)regular[i][j];
   }
 }

 for(i=0; i<no_rows; i++)
 {
   for(j=0; j<no_cols; j++)
   {
    transposed[j][i] = interim[i][j];
   }
 }
 
 freeDoubleMat(interim, no_rows);
}

/* Function to perform the partial-pivoting Gaussian elimination.
   a[][] is the original matrix in the input and transformed
   matrix plus the pivoting element ratios below the diagonal
   in the output.  indx[] records the pivoting order.
   Copyright (c) Tao Pang 2001. */
/* This function is required in the following migs function to invert a matrix. */
void elgs(double **a, int n, int *indx)
{
  int i, j, k, itmp;
  double c1, pi, pi1, pj;
  double c[n];

/* Initialize the index */

  for (i = 0; i < n; ++i)
  {
    indx[i] = i;
  }

/* Find the rescaling factors, one from each row */

  for (i = 0; i < n; ++i)
  {
    c1 = 0;
    for (j = 0; j < n; ++j)
    {
      if (fabs(a[i][j]) > c1) c1 = fabs(a[i][j]);
    }
    c[i] = c1;
  }

/* Search the pivoting (largest) element from each column */

  for (j = 0; j < n-1; ++j)
  {
    pi1 = 0;
    for (i = j; i < n; ++i)
    {
      pi = fabs(a[indx[i]][j])/c[indx[i]];
      if (pi > pi1)
      {
        pi1 = pi;
        k = i;
      }
    }

/* Interchange the rows via indx[] to record pivoting order */

    itmp = indx[j];
    indx[j] = indx[k];
    indx[k] = itmp;
    for (i = j+1; i < n; ++i)
    {
      pj = a[indx[i]][j]/a[indx[j]][j];

/* Record pivoting ratios below the diagonal */

      a[indx[i]][j] = pj;

/* Modify other elements accordingly */

      for (k = j+1; k < n; ++k)
      {
        a[indx[i]][k] = a[indx[i]][k]-pj*a[indx[j]][k];
      }
    }
  }
}       /* End of elgs fuction */


/* Function to invert matrix a[][] with the inverse stored
in x[][] in the output.  Copyright (c) Tao Pang 2001. */
void migs(double **a, int n, double **x, int *indx)
{
  int i,j,k;
  double b[n][n];

  for (i = 0; i < n; ++i)
  {
    for (j = 0; j < n; ++j)
    {
      b[i][j] = 0;
    }
  }
  for (i = 0; i < n; ++i)
  {
    b[i][i] = 1;
  }

  elgs(a,n,indx);

  for (i = 0; i < n-1; ++i)
  {
    for (j = i+1; j < n; ++j)
    {
      for (k = 0; k < n; ++k)
      {
        b[indx[j]][k] = b[indx[j]][k]-a[indx[j]][i]*b[indx[i]][k];
      }
    }
  }

for (i = 0; i < n; ++i)
  {
    x[n-1][i] = b[indx[n-1]][i]/a[indx[n-1]][n-1];
    for (j = n-2; j >= 0; j = j-1)
    {
      x[j][i] = b[indx[j]][i];
      for (k = j+1; k < n; ++k)
      {
        x[j][i] = x[j][i]-a[indx[j]][k]*x[k][i];
      }
      x[j][i] = x[j][i]/a[indx[j]][j];
    }
  }
}       /* End function migs */

/*Function to perform Cholesky decompostion*/
void Cholesky(double **A, int size, double **Res) {
    int i, j, k;
    double x, y;

		double *a = OnedDoubleMemAlloc(size*size);
		MatDecomp(A, size, size, a, 1);

    for (j = 0; j < size; ++j) {
        x = 0.0;
        for (i = 0; i < j; ++i) {
            a[i+j*size] = 0.0;
            x += a[j+i*size] * a[j+i*size];
        }
        x = sqrt(a[j+j*size]-x);
        a[j+j*size] = x;
        for (i = j+1; i < size; ++i) {
            y = 0.0;
            for (k = 0; k < j; ++k)
                y += a[i+k*size] * a[j+k*size];
           a[i+j*size] = (a[i+j*size] - y) / x;
        }
    }
		MatRecomp(a, size, size, Res, 1);
		free(a);
}

