#### Initializing BLMM and specifying the prior parameters
## Fit the least squares model
s2.LS <- BETA.LS <- NULL
for(i in 1:n) 
{
  fit<-lm(Ytop[i,,o]~-1+Xi)
  BETA.LS<-rbind(BETA.LS,c(fit$coef)) 
  s2.LS<-c(s2.LS, summary(fit)$sigma^2) 
} 

nu0 <-1; s2 <- s20 <- mean(s2.LS)
BETA_0 <-BETA<- apply(BETA.LS,2,mean)
eta0 <- r+2 ;  Sigma0 <-cov(BETA.LS)
D <-S0 <- Sigma0 [1:r,1:r]
iSigma0 <-solve(Sigma0) ; iD <- solve(D)
beta <- matrix(NA,n,r)
iD.ll <- matrix(0,r,r)
BETA.ll<-BETA*0

BETA_ps<-matrix(NA,d,length(S[thin]))                         ## fixed effects samples
for(s in 1:S) 
{
  ## Update beta_i 
  for(i in 1:n) 
  {  
    V<-solve( iD + t(Zi)%*%Zi/s2 )
    m<-V%*%( t(Zi)%*%(matrix(Ytop[i,,o]) - Xi%*%BETA)/s2 )
    beta[i,]<-rmvnorm(1,m,V) 
  } 
  
  ## Update BETA
  RSS<-0
  SumXX<-0
  SumXYZ<-0
  for(i in 1:n)
  {
    SumXX<-SumXX+t(Xi)%*%Xi
    SumXYZ<-SumXYZ+(t(Xi)%*%(matrix(Ytop[i,,o]) - Zi%*%matrix(beta[i,])))
  }
  Lm <-  solve(SumXX/s2 + iSigma0)
  mum<- Lm%*%(SumXYZ/s2 + iSigma0%*%BETA_0)
  BETA<-t(rmvnorm(1,mum,Lm))
  
  ## Update Sigma
  iD<-rwish( eta0+n, solve(S0+t(beta)%*%beta)) 
  
  ## Update s2
  temp<-matrix(NA, n, M)
  for(i in 1:n)
  {
    temp[i,]<-matrix(Ytop[i,,o]) - (Xi%*%BETA + Zi%*%matrix(beta[i,]))
  }
  RSS<-sum(diag((temp)%*%t(temp)))
  s2<-1/rgamma(1,(nu0+n*M)/2, (nu0*s20+RSS)/2 )

  ## Storing parameter estimates and random effects.
  s2_ps[s==thin,o]<-s2  
  D_ps[s==thin,o]<-1/iD
  BETA_ps[,s==thin]<-BETA
  beta_ps[,s==thin,o]<-beta
}#s

