% ftcs - Programme to solve the  
% advection equation using FTCS. 
clear; help ftcs;
tau=input('Enter time step -');
N=input('Enter number of grid points -');
L=1.;
h=L/N;
v=1.;
coeff=-v*tau/(2.*h);
sigma=0.1;
kwave=pi/sigma;
x=((1:N)-1/2)*h-L/2;
u=cos(kwave*x).*exp(-x.^2/(2*sigma^2));		% Initial condition
iplot=1;
uplot(:,1)=u(:);
tplot(1)=0.;
nstep=floor(L/(v*tau));
plotstep=ceil(nstep/50);
for i=1:nstep
	unew(2:(N-1))=u(2:(N-1))...					% FTCS method
		+coeff*(u(3:N)-u(1:(N-2)));
	unew(1)=u(1)+coeff*(u(2)-u(N));				% Periodic boundary
	unew(N)=u(N)+coeff*(u(1)-u(N-1));			% conditions.
	u=unew;
	if(rem(i,plotstep)<1)
		iplot=iplot+1;
		uplot(:,iplot)=u(:);
		tplot(iplot)=tau*i;
		fprintf('%g out of %g steps... completed\n',i,nstep);
	end
end
plot(x,uplot(:,1),'-',x,u,'--');
xlabel('x');ylabel('u(x,t)');
title('Initial and final amplitudes');
pause;
mesh(uplot,[-100 60]);
xlabel('Position');ylabel('Time');
title('Amplitude versus x and t');	
